/*
 * Decompiled with CFR 0.152.
 */
package com.carmatech.cassandra;

import com.eaio.uuid.UUIDGen;
import java.util.Date;
import java.util.UUID;
import org.joda.time.DateTime;

public final class TimeUUID {
    private static final long NUM_100NS_INTERVALS_SINCE_UUID_EPOCH = 122192928000000000L;
    private static long lastTimestamp = Long.MIN_VALUE;

    private TimeUUID() {
    }

    public static synchronized void reset() {
        lastTimestamp = Long.MIN_VALUE;
    }

    public static UUID createUUID() {
        return TimeUUID.createUUID(System.currentTimeMillis());
    }

    public static UUID createUUID(DateTime dateTime) {
        return TimeUUID.createUUID(dateTime.getMillis());
    }

    public static UUID createUUID(Date javaDate) {
        return TimeUUID.createUUID(javaDate.getTime());
    }

    public static UUID createUUID(long timestamp) {
        long timestampIn100Ns = TimeUUID.to100Ns(timestamp);
        long uniqueTimestampIn100Ns = TimeUUID.makeUnique(timestampIn100Ns);
        return new UUID(TimeUUID.toUUIDTime(uniqueTimestampIn100Ns), UUIDGen.getClockSeqAndNode());
    }

    private static long to100Ns(long timestampInMs) {
        return timestampInMs * 10000L + 122192928000000000L;
    }

    private static synchronized long makeUnique(long timestamp) {
        if (timestamp > lastTimestamp) {
            lastTimestamp = timestamp;
            return timestamp;
        }
        return ++lastTimestamp;
    }

    private static long toUUIDTime(long timestampIn100Ns) {
        long uuidTime = timestampIn100Ns << 32 | 0x1000L;
        uuidTime |= (timestampIn100Ns & 0xFFFF00000000L) >>> 16;
        return uuidTime |= (timestampIn100Ns & 0xFFFF000000000000L) >>> 48;
    }

    public static UUID toUUID(DateTime dateTime) {
        return TimeUUID.toUUID(dateTime.getMillis());
    }

    public static UUID toUUID(Date javaDate) {
        return TimeUUID.toUUID(javaDate.getTime());
    }

    public static UUID toUUID(long timestamp) {
        long timestampIn100Ns = TimeUUID.to100Ns(timestamp);
        return new UUID(TimeUUID.toUUIDTime(timestampIn100Ns), UUIDGen.getClockSeqAndNode());
    }

    public static long toMillis(UUID uuid) {
        return TimeUUID.from100Ns(uuid.timestamp());
    }

    private static long from100Ns(long timestampIn100Ns) {
        return (timestampIn100Ns - 122192928000000000L) / 10000L;
    }
}

