/*
 * Decompiled with CFR 0.152.
 */
package com.carmatech.cassandra;

import com.google.common.base.Preconditions;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.MutableDateTime;

public enum ShardingFrequency {
    SECONDLY(1000L),
    MINUTELY(60000L),
    HOURLY(3600000L),
    DAILY(86400000L),
    WEEKLY(604800000L),
    MONTHLY(2592000000L);

    private final long frequencyInMillis;
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long ROW_MAX_SIZE = 0xA00000L;

    private ShardingFrequency(long frequencyInMillis) {
        this.frequencyInMillis = frequencyInMillis;
    }

    public long toMillis() {
        return this.frequencyInMillis;
    }

    public static ShardingFrequency calculateFrequency(long averageSizeInBytes, long writesPerTimeUnit, TimeUnit timeUnit) {
        return ShardingFrequency.calculateFrequency(averageSizeInBytes, writesPerTimeUnit, timeUnit, 0xA00000L);
    }

    public static ShardingFrequency calculateFrequency(long averageSizeInBytes, long writesPerTimeUnit, TimeUnit timeUnit, long rowMaxSizeInBytes) {
        double shardingFrequencyInMillis = timeUnit.toMillis(1L) * rowMaxSizeInBytes / averageSizeInBytes / writesPerTimeUnit;
        if (shardingFrequencyInMillis > (double)MONTHLY.toMillis()) {
            return MONTHLY;
        }
        if (shardingFrequencyInMillis > (double)WEEKLY.toMillis()) {
            return WEEKLY;
        }
        if (shardingFrequencyInMillis > (double)DAILY.toMillis()) {
            return DAILY;
        }
        if (shardingFrequencyInMillis > (double)HOURLY.toMillis()) {
            return HOURLY;
        }
        if (shardingFrequencyInMillis > (double)MINUTELY.toMillis()) {
            return MINUTELY;
        }
        if (shardingFrequencyInMillis > (double)SECONDLY.toMillis()) {
            return SECONDLY;
        }
        throw new RuntimeException("Sharding will be too aggressive as bucket size is: " + shardingFrequencyInMillis + " ms. You may want to reconsider your data storage strategy.");
    }

    public static long calculateBucket(long timestamp, ShardingFrequency frequency) {
        MutableDateTime dateTime = new MutableDateTime(timestamp);
        if (frequency.compareTo(SECONDLY) >= 0) {
            dateTime.setMillisOfSecond(0);
        }
        if (frequency.compareTo(MINUTELY) >= 0) {
            dateTime.setSecondOfMinute(0);
        }
        if (frequency.compareTo(HOURLY) >= 0) {
            dateTime.setMinuteOfHour(0);
        }
        if (frequency.compareTo(DAILY) >= 0) {
            dateTime.setHourOfDay(0);
        }
        if (frequency.compareTo(WEEKLY) >= 0) {
            dateTime.setDayOfWeek(1);
        }
        if (frequency.compareTo(MONTHLY) >= 0) {
            dateTime.setDayOfMonth(1);
        }
        return dateTime.getMillis();
    }

    public static Set<Long> getBuckets(long from, long to, ShardingFrequency frequency) {
        Preconditions.checkArgument((from <= to ? 1 : 0) != 0, (Object)("'To' timestamp must be greater than, or equal to 'from' timestamp: 'from'=[" + from + "], 'to'=[" + to + "]."));
        LinkedHashSet<Long> buckets = new LinkedHashSet<Long>();
        buckets.add(ShardingFrequency.calculateBucket(from, frequency));
        for (long timestamp = from + frequency.toMillis(); timestamp < to; timestamp += frequency.toMillis()) {
            buckets.add(ShardingFrequency.calculateBucket(timestamp, frequency));
        }
        buckets.add(ShardingFrequency.calculateBucket(to, frequency));
        return buckets;
    }
}

