/*
 * Decompiled with CFR 0.152.
 */
package com.carmatech.cassandra;

import com.eaio.uuid.UUID;
import com.eaio.uuid.UUIDGen;
import java.util.Date;
import org.joda.time.DateTime;

public final class CorbaTimeUUID {
    private static final long NUM_100NS_INTERVALS_SINCE_UUID_EPOCH = 122192928000000000L;
    private static long lastTimestamp = Long.MIN_VALUE;

    private CorbaTimeUUID() {
    }

    public static synchronized void reset() {
        lastTimestamp = Long.MIN_VALUE;
    }

    public static UUID createUUID() {
        return CorbaTimeUUID.createUUID(System.currentTimeMillis());
    }

    public static UUID createUUID(DateTime dateTime) {
        return CorbaTimeUUID.createUUID(dateTime.getMillis());
    }

    public static UUID createUUID(Date javaDate) {
        return CorbaTimeUUID.createUUID(javaDate.getTime());
    }

    public static UUID createUUID(long timestamp) {
        long timestampIn100Ns = CorbaTimeUUID.to100Ns(timestamp);
        long uniqueTimestampIn100Ns = CorbaTimeUUID.makeUnique(timestampIn100Ns);
        return new UUID(CorbaTimeUUID.toUUIDTime(uniqueTimestampIn100Ns), UUIDGen.getClockSeqAndNode());
    }

    private static long to100Ns(long timestampInMs) {
        return timestampInMs * 10000L + 122192928000000000L;
    }

    private static synchronized long makeUnique(long timestamp) {
        if (timestamp > lastTimestamp) {
            lastTimestamp = timestamp;
            return timestamp;
        }
        return ++lastTimestamp;
    }

    private static long toUUIDTime(long timestampIn100Ns) {
        long uuidTime = timestampIn100Ns << 32 | 0x1000L;
        uuidTime |= (timestampIn100Ns & 0xFFFF00000000L) >>> 16;
        return uuidTime |= (timestampIn100Ns & 0xFFFF000000000000L) >>> 48;
    }

    public static UUID toUUID(DateTime dateTime) {
        return CorbaTimeUUID.toUUID(dateTime.getMillis());
    }

    public static UUID toUUID(Date javaDate) {
        return CorbaTimeUUID.toUUID(javaDate.getTime());
    }

    public static UUID toUUID(long timestamp) {
        long timestampIn100Ns = CorbaTimeUUID.to100Ns(timestamp);
        return new UUID(CorbaTimeUUID.toUUIDTime(timestampIn100Ns), UUIDGen.getClockSeqAndNode());
    }

    public static long toMillis(UUID uuid) {
        return CorbaTimeUUID.from100Ns(CorbaTimeUUID.fromUUIDTime(uuid.getTime()));
    }

    private static long from100Ns(long timestampIn100Ns) {
        return (timestampIn100Ns - 122192928000000000L) / 10000L;
    }

    private static long fromUUIDTime(long uuidTime) {
        long timestampIn100Ns = uuidTime >>> 32;
        timestampIn100Ns |= (uuidTime & 0xFFFF0000L) << 16;
        return timestampIn100Ns |= (uuidTime & 0xFFFL) << 48;
    }
}

