/*
 * Decompiled with CFR 0.152.
 */
package com.cardinalblue.gesture;

import android.graphics.PointF;
import android.view.MotionEvent;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J)\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/cardinalblue/gesture/PointerUtils;", "", "()V", "DELTA_RADIANS", "", "DELTA_SCALE_X", "DELTA_SCALE_Y", "DELTA_X", "DELTA_Y", "PIVOT_X", "PIVOT_Y", "getFocusIndexFromId", "event", "Landroid/view/MotionEvent;", "targetId", "getTransformFromPointers", "", "startPointers", "", "Landroid/graphics/PointF;", "stopPointers", "([Landroid/graphics/PointF;[Landroid/graphics/PointF;)[F", "collage-gesture-detector_release"})
public final class PointerUtils {
    public static final int DELTA_X = 0;
    public static final int DELTA_Y = 1;
    public static final int DELTA_SCALE_X = 2;
    public static final int DELTA_SCALE_Y = 3;
    public static final int DELTA_RADIANS = 4;
    public static final int PIVOT_X = 5;
    public static final int PIVOT_Y = 6;
    public static final PointerUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final float[] getTransformFromPointers(@NotNull PointF[] startPointers, @NotNull PointF[] stopPointers) {
        float dScale;
        Intrinsics.checkParameterIsNotNull((Object)startPointers, (String)"startPointers");
        Intrinsics.checkParameterIsNotNull((Object)stopPointers, (String)"stopPointers");
        if (startPointers.length < 2 || stopPointers.length < 2) {
            throw (Throwable)new IllegalStateException("The event must have at least two down pointers.");
        }
        float[] transform = new float[]{0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
        float startX1 = startPointers[0].x;
        float startY1 = startPointers[0].y;
        float startX2 = startPointers[1].x;
        float startY2 = startPointers[1].y;
        float stopX1 = stopPointers[0].x;
        float stopY1 = stopPointers[0].y;
        float stopX2 = stopPointers[1].x;
        float stopY2 = stopPointers[1].y;
        float startVecX = startX2 - startX1;
        float startVecY = startY2 - startY1;
        float stopVecX = stopX2 - stopX1;
        float stopVecY = stopY2 - stopY1;
        float startPivotX = (startX1 + startX2) / 2.0f;
        float startPivotY = (startY1 + startY2) / 2.0f;
        float stopPivotX = (stopX1 + stopX2) / 2.0f;
        float stopPivotY = (stopY1 + stopY2) / 2.0f;
        transform[0] = stopPivotX - startPivotX;
        transform[1] = stopPivotY - startPivotY;
        transform[4] = startVecX == 0.0f && startVecY == 0.0f && stopVecX == 0.0f && stopVecY == 0.0f ? 0.0f : (float)(Math.atan2(stopVecY, stopVecX) - Math.atan2(startVecY, startVecX));
        transform[2] = dScale = startVecX == 0.0f && startVecY == 0.0f && stopVecX == 0.0f && stopVecY == 0.0f ? 1.0f : (float)(Math.hypot(stopVecX, stopVecY) / Math.hypot(startVecX, startVecY));
        transform[3] = dScale;
        transform[5] = startPivotX;
        transform[6] = startPivotY;
        return transform;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final int getFocusIndexFromId(@NotNull MotionEvent event, int targetId) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        int n = 0;
        int n2 = event.getPointerCount();
        while (n < n2) {
            void i;
            int id = event.getPointerId((int)i);
            if (id == targetId) {
                return (int)i;
            }
            ++i;
        }
        throw (Throwable)new IllegalStateException("Cannot find the focus index");
    }

    private PointerUtils() {
    }

    static {
        PointerUtils pointerUtils;
        INSTANCE = pointerUtils = new PointerUtils();
    }
}

