/*
 * Decompiled with CFR 0.152.
 */
package com.cardinalblue.gesture.state;

import android.graphics.PointF;
import android.os.Message;
import android.util.SparseArray;
import android.view.MotionEvent;
import com.cardinalblue.gesture.IGestureStateOwner;
import com.cardinalblue.gesture.state.BaseGestureState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0016J$\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0016J$\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/cardinalblue/gesture/state/MultipleFingersIdleState;", "Lcom/cardinalblue/gesture/state/BaseGestureState;", "owner", "Lcom/cardinalblue/gesture/IGestureStateOwner;", "mTouchSlopSquare", "", "(Lcom/cardinalblue/gesture/IGestureStateOwner;I)V", "mStartPointers", "Landroid/util/SparseArray;", "Landroid/graphics/PointF;", "mStopPointers", "isConsideredPinch", "", "startPointers", "stopPointers", "onDoing", "", "event", "Landroid/view/MotionEvent;", "target", "", "context", "onEnter", "onExit", "onHandleMessage", "msg", "Landroid/os/Message;", "collage-gesture-detector_release"})
public final class MultipleFingersIdleState
extends BaseGestureState {
    private final SparseArray<PointF> mStartPointers;
    private final SparseArray<PointF> mStopPointers;
    private final int mTouchSlopSquare;

    /*
     * WARNING - void declaration
     */
    @Override
    public void onEnter(@NotNull MotionEvent event, @Nullable Object target, @Nullable Object context) {
        int upIndex;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        String string = "gesture enter " + this.getClass().getSimpleName();
        System.out.println((Object)string);
        int action = event.getActionMasked();
        boolean pointerUp = action == 6;
        int n = upIndex = pointerUp ? event.getActionIndex() : -1;
        if (action == 1 || action == 3) {
            this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_IDLE, event, target, context);
        } else {
            boolean isMultipleFingers;
            boolean isUp = action == 6;
            int pressCount = event.getPointerCount() - (isUp ? 1 : 0);
            boolean bl = isMultipleFingers = pressCount > 1;
            if (isMultipleFingers) {
                this.mStartPointers.clear();
                this.mStopPointers.clear();
                int n2 = 0;
                int n3 = event.getPointerCount();
                while (n2 < n3) {
                    void i;
                    if (i != upIndex) {
                        int id = event.getPointerId((int)i);
                        this.mStartPointers.put(id, (Object)new PointF(event.getX((int)i), event.getY((int)i)));
                        this.mStopPointers.put(id, (Object)new PointF(event.getX((int)i), event.getY((int)i)));
                    }
                    ++i;
                }
            } else {
                this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_SINGLE_FINGER_PRESSING, event, target, context);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onDoing(@NotNull MotionEvent event, @Nullable Object target, @Nullable Object context) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        int action = event.getActionMasked();
        boolean pointerUp = action == 6;
        int upIndex = pointerUp ? event.getActionIndex() : -1;
        int downPointerCount = event.getPointerCount() - (pointerUp ? 1 : 0);
        switch (action) {
            case 2: {
                if (downPointerCount >= 2) {
                    int n = 0;
                    int n2 = event.getPointerCount();
                    while (n < n2) {
                        void i;
                        if (i != upIndex) {
                            PointF pointer;
                            int id = event.getPointerId((int)i);
                            PointF pointF = pointer = (PointF)this.mStopPointers.get(id);
                            if (pointF != null) {
                                pointF.set(event.getX((int)i), event.getY((int)i));
                            }
                        }
                        ++i;
                    }
                    if (!this.isConsideredPinch(this.mStartPointers, this.mStopPointers)) break;
                    this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_PINCH, event, target, context);
                    break;
                }
                this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_SINGLE_FINGER_PRESSING, event, target, context);
                break;
            }
            case 5: {
                int downIndex = event.getActionIndex();
                int downId = event.getPointerId(downIndex);
                this.mStartPointers.put(downId, (Object)new PointF(event.getX(downIndex), event.getY(downIndex)));
                this.mStopPointers.put(downId, (Object)new PointF(event.getX(downIndex), event.getY(downIndex)));
                break;
            }
            case 6: {
                boolean isMultipleFingers;
                int upId = event.getPointerId(upIndex);
                this.mStartPointers.remove(upId);
                this.mStopPointers.remove(upId);
                boolean bl = isMultipleFingers = downPointerCount > 1;
                if (isMultipleFingers) break;
                this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_SINGLE_FINGER_PRESSING, event, target, context);
                break;
            }
            case 1: 
            case 3: {
                this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_IDLE, event, target, context);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isConsideredPinch(SparseArray<PointF> startPointers, SparseArray<PointF> stopPointers) {
        int size = Math.min(startPointers.size(), stopPointers.size());
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            PointF start = (PointF)startPointers.get(startPointers.keyAt((int)i));
            PointF stop = (PointF)stopPointers.get(stopPointers.keyAt((int)i));
            float dx = stop.x - start.x;
            float dy = stop.y - start.y;
            if (dx * dx + dy * dy > (float)this.mTouchSlopSquare) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void onExit(@NotNull MotionEvent event, @Nullable Object target, @Nullable Object context) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        String string = "gesture exit " + this.getClass().getSimpleName();
        System.out.println((Object)string);
        this.mStartPointers.clear();
        this.mStopPointers.clear();
    }

    @Override
    public boolean onHandleMessage(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        return false;
    }

    public MultipleFingersIdleState(@NotNull IGestureStateOwner owner, int mTouchSlopSquare) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        super(owner);
        this.mTouchSlopSquare = mTouchSlopSquare;
        this.mStartPointers = new SparseArray();
        this.mStopPointers = new SparseArray();
    }
}

