/*
 * Decompiled with CFR 0.152.
 */
package com.cardinalblue.gesture.state;

import android.os.Message;
import android.view.MotionEvent;
import com.cardinalblue.gesture.IGestureStateOwner;
import com.cardinalblue.gesture.PointerUtils;
import com.cardinalblue.gesture.state.BaseGestureState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016J$\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016J$\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/cardinalblue/gesture/state/SingleFingerPressingStateForDragOnly;", "Lcom/cardinalblue/gesture/state/BaseGestureState;", "owner", "Lcom/cardinalblue/gesture/IGestureStateOwner;", "mTouchSlopSquare", "", "(Lcom/cardinalblue/gesture/IGestureStateOwner;J)V", "mStartFocusId", "", "mStartFocusX", "", "mStartFocusY", "onDoing", "", "event", "Landroid/view/MotionEvent;", "target", "", "context", "onEnter", "onExit", "onHandleMessage", "", "msg", "Landroid/os/Message;", "collage-gesture-detector_release"})
public final class SingleFingerPressingStateForDragOnly
extends BaseGestureState {
    private int mStartFocusId;
    private float mStartFocusX;
    private float mStartFocusY;
    private final long mTouchSlopSquare;

    @Override
    public void onEnter(@NotNull MotionEvent event, @Nullable Object target, @Nullable Object context) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.mStartFocusId = event.getPointerId(event.getActionIndex());
        int focusIndex = PointerUtils.INSTANCE.getFocusIndexFromId(event, this.mStartFocusId);
        this.mStartFocusX = event.getX(focusIndex);
        this.mStartFocusY = event.getY(focusIndex);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onDoing(@NotNull MotionEvent event, @Nullable Object target, @Nullable Object context) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        int action = event.getActionMasked();
        int focusIndex = PointerUtils.INSTANCE.getFocusIndexFromId(event, this.mStartFocusId);
        float focusX = event.getX(focusIndex);
        float focusY = event.getY(focusIndex);
        switch (action) {
            case 5: {
                break;
            }
            case 6: {
                int upIndex = event.getActionIndex();
                if (focusIndex != upIndex) break;
                int newFocusIndex = -1;
                int n = 0;
                int n2 = event.getPointerCount();
                while (n < n2) {
                    void i;
                    if (i != upIndex) {
                        this.mStartFocusId = event.getPointerId((int)i);
                        newFocusIndex = i;
                        break;
                    }
                    ++i;
                }
                if (newFocusIndex == -1) {
                    throw (Throwable)new IllegalStateException("Cannot find other focus pointer");
                }
                focusX = event.getX(newFocusIndex);
                focusY = event.getY(newFocusIndex);
                this.mStartFocusX = focusX;
                this.mStartFocusY = focusY;
                break;
            }
            case 2: {
                int deltaX = (int)(focusX - this.mStartFocusX);
                int deltaY = (int)(focusY - this.mStartFocusY);
                int distance = deltaX * deltaX + deltaY * deltaY;
                if ((long)distance <= this.mTouchSlopSquare) break;
                this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_DRAG, event, target, context);
                break;
            }
            case 1: 
            case 3: {
                this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_IDLE, event, target, context);
            }
        }
    }

    @Override
    public void onExit(@NotNull MotionEvent event, @Nullable Object target, @Nullable Object context) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
    }

    @Override
    public boolean onHandleMessage(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        return false;
    }

    public SingleFingerPressingStateForDragOnly(@NotNull IGestureStateOwner owner, long mTouchSlopSquare) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        super(owner);
        this.mTouchSlopSquare = mTouchSlopSquare;
        this.mStartFocusId = -1;
    }
}

