/*
 * Decompiled with CFR 0.152.
 */
package com.cardinalblue.gesture.state;

import android.os.Message;
import android.view.MotionEvent;
import com.cardinalblue.gesture.IAllGesturesListener;
import com.cardinalblue.gesture.IGestureStateOwner;
import com.cardinalblue.gesture.state.BaseGestureState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J$\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J$\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/cardinalblue/gesture/state/IdleState;", "Lcom/cardinalblue/gesture/state/BaseGestureState;", "owner", "Lcom/cardinalblue/gesture/IGestureStateOwner;", "(Lcom/cardinalblue/gesture/IGestureStateOwner;)V", "mIsMultitouchEnabled", "", "onDoing", "", "event", "Landroid/view/MotionEvent;", "target", "", "context", "onEnter", "onExit", "onHandleMessage", "msg", "Landroid/os/Message;", "setIsTransitionToMultiTouchEnabled", "enabled", "collage-gesture-detector_release"})
public final class IdleState
extends BaseGestureState {
    private boolean mIsMultitouchEnabled;

    @Override
    public void onEnter(@NotNull MotionEvent event, @Nullable Object target, @Nullable Object context) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            IAllGesturesListener iAllGesturesListener = this.getOwner().getListener();
            if (iAllGesturesListener == null) break block0;
            iAllGesturesListener.onActionEnd(this.obtainMyMotionEvent(event), target, context);
        }
    }

    @Override
    public void onDoing(@NotNull MotionEvent event, @Nullable Object target, @Nullable Object context) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        int action = event.getActionMasked();
        switch (action) {
            case 0: {
                boolean isSingleFinger;
                boolean bl = isSingleFinger = event.getPointerCount() == 1;
                if (isSingleFinger || !this.mIsMultitouchEnabled) {
                    this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_SINGLE_FINGER_PRESSING, event, target, context);
                    break;
                }
                this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_MULTIPLE_FINGERS_PRESSING, event, target, context);
            }
        }
    }

    @Override
    public void onExit(@NotNull MotionEvent event, @Nullable Object target, @Nullable Object context) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            IAllGesturesListener iAllGesturesListener = this.getOwner().getListener();
            if (iAllGesturesListener == null) break block0;
            iAllGesturesListener.onActionBegin(this.obtainMyMotionEvent(event), target, context);
        }
    }

    @Override
    public boolean onHandleMessage(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        return true;
    }

    public final void setIsTransitionToMultiTouchEnabled(boolean enabled) {
        this.mIsMultitouchEnabled = enabled;
    }

    public IdleState(@NotNull IGestureStateOwner owner) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        super(owner);
        this.mIsMultitouchEnabled = true;
    }
}

