/*
 * Decompiled with CFR 0.152.
 */
package com.cardinalblue.gesture;

import android.graphics.PointF;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/cardinalblue/gesture/PointerUtils;", "", "()V", "DELTA_RADIANS", "", "DELTA_SCALE_X", "DELTA_SCALE_Y", "DELTA_X", "DELTA_Y", "getTransformFromPointers", "", "startPointers", "", "Landroid/graphics/PointF;", "stopPointers", "([Landroid/graphics/PointF;[Landroid/graphics/PointF;)[F", "collage-gesture-detector_release"})
public final class PointerUtils {
    public static final int DELTA_X = 0;
    public static final int DELTA_Y = 1;
    public static final int DELTA_SCALE_X = 2;
    public static final int DELTA_SCALE_Y = 3;
    public static final int DELTA_RADIANS = 4;
    public static final PointerUtils INSTANCE;

    @NotNull
    public final float[] getTransformFromPointers(@NotNull PointF[] startPointers, @NotNull PointF[] stopPointers) {
        float dScale;
        Intrinsics.checkParameterIsNotNull((Object)startPointers, (String)"startPointers");
        Intrinsics.checkParameterIsNotNull((Object)stopPointers, (String)"stopPointers");
        if (((Object[])startPointers).length < 2 || ((Object[])stopPointers).length < 2) {
            throw (Throwable)new IllegalStateException("The event must have at least two down pointers.");
        }
        float[] transform = new float[]{0.0f, 0.0f, 1.0f, 1.0f, 0.0f};
        float startX1 = startPointers[0].x;
        float startY1 = startPointers[0].y;
        float startX2 = startPointers[1].x;
        float startY2 = startPointers[1].y;
        float stopX1 = stopPointers[0].x;
        float stopY1 = stopPointers[0].y;
        float stopX2 = stopPointers[1].x;
        float stopY2 = stopPointers[1].y;
        float startVecX = startX2 - startX1;
        float startVecY = startY2 - startY1;
        float stopVecX = stopX2 - stopX1;
        float stopVecY = stopY2 - stopY1;
        float startPivotX = (startX1 + startX2) / 2.0f;
        float startPivotY = (startY1 + startY2) / 2.0f;
        float stopPivotX = (stopX1 + stopX2) / 2.0f;
        float stopPivotY = (stopY1 + stopY2) / 2.0f;
        transform[0] = stopPivotX - startPivotX;
        transform[1] = stopPivotY - startPivotY;
        transform[4] = (float)(Math.atan2(stopVecY, stopVecX) - Math.atan2(startVecY, startVecX));
        transform[2] = dScale = (float)(Math.hypot(stopVecX, stopVecY) / Math.hypot(startVecX, startVecY));
        transform[3] = dScale;
        return transform;
    }

    private PointerUtils() {
    }

    static {
        PointerUtils pointerUtils;
        INSTANCE = pointerUtils = new PointerUtils();
    }
}

