/*
 * Decompiled with CFR 0.152.
 */
package com.cardinalblue.gesture.state;

import android.os.Message;
import android.view.MotionEvent;
import com.cardinalblue.gesture.IGestureListener;
import com.cardinalblue.gesture.IGestureStateOwner;
import com.cardinalblue.gesture.MyMotionEvent;
import com.cardinalblue.gesture.state.BaseGestureState;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 02\u00020\u0001:\u00010B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\u001c\u0010\"\u001a\u00020\u000b2\b\u0010#\u001a\u0004\u0018\u00010\u00122\b\u0010$\u001a\u0004\u0018\u00010\u0012H\u0002J$\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u00122\b\u0010'\u001a\u0004\u0018\u00010\u001d2\b\u0010(\u001a\u0004\u0018\u00010\u001dH\u0016J$\u0010)\u001a\u00020 2\u0006\u0010&\u001a\u00020\u00122\b\u0010'\u001a\u0004\u0018\u00010\u001d2\b\u0010(\u001a\u0004\u0018\u00010\u001dH\u0016J$\u0010*\u001a\u00020 2\u0006\u0010&\u001a\u00020\u00122\b\u0010'\u001a\u0004\u0018\u00010\u001d2\b\u0010(\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020-H\u0016J\u000e\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u00020\u000bR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/cardinalblue/gesture/state/SingleFingerPressingState;", "Lcom/cardinalblue/gesture/state/BaseGestureState;", "owner", "Lcom/cardinalblue/gesture/IGestureStateOwner;", "mTapSlopSquare", "", "mTouchSlopSquare", "mTapTimeout", "mLongPressTimeout", "(Lcom/cardinalblue/gesture/IGestureStateOwner;JJJJ)V", "isLongPressEnabled", "", "()Z", "setLongPressEnabled", "(Z)V", "isTapEnabled", "setTapEnabled", "mCurrentDownEvent", "Landroid/view/MotionEvent;", "mCurrentUpEvent", "mHadLongPress", "mIsMultitouchEnabled", "mPreviousDownEvent", "mStartFocusX", "", "mStartFocusY", "mTapCount", "", "mTouchingContext", "", "mTouchingObject", "cancelLongPress", "", "cancelTaps", "isConsideredCloseTap", "previousDown", "currentDown", "onDoing", "event", "target", "context", "onEnter", "onExit", "onHandleMessage", "msg", "Landroid/os/Message;", "setIsTransitionToMultiTouchEnabled", "enabled", "Companion", "collage-gesture-detector_release"})
public final class SingleFingerPressingState
extends BaseGestureState {
    private boolean isTapEnabled;
    private boolean isLongPressEnabled;
    private boolean mIsMultitouchEnabled;
    private boolean mHadLongPress;
    private int mTapCount;
    private float mStartFocusX;
    private float mStartFocusY;
    private MotionEvent mPreviousDownEvent;
    private MotionEvent mCurrentDownEvent;
    private MotionEvent mCurrentUpEvent;
    private Object mTouchingObject;
    private Object mTouchingContext;
    private final long mTapSlopSquare;
    private final long mTouchSlopSquare;
    private final long mTapTimeout;
    private final long mLongPressTimeout;
    private static final int MSG_TAP = 161;
    private static final int MSG_LONG_PRESS = 162;
    public static final Companion Companion = new Companion(null);

    public final boolean isTapEnabled() {
        return this.isTapEnabled;
    }

    public final void setTapEnabled(boolean bl) {
        this.isTapEnabled = bl;
    }

    public final boolean isLongPressEnabled() {
        return this.isLongPressEnabled;
    }

    public final void setLongPressEnabled(boolean bl) {
        this.isLongPressEnabled = bl;
    }

    @Override
    public void onEnter(@NotNull MotionEvent event, @Nullable Object target, @Nullable Object context) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.mTapCount = 0;
        this.mHadLongPress = false;
        this.mTouchingObject = target;
        this.mTouchingContext = context;
        this.onDoing(event, target, context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onDoing(@NotNull MotionEvent event, @Nullable Object target, @Nullable Object context) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        int action = event.getActionMasked();
        boolean pointerUp = action == 6;
        int upIndex = pointerUp ? event.getActionIndex() : -1;
        float sumX = 0.0f;
        float sumY = 0.0f;
        int count = event.getPointerCount();
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void i;
            if (upIndex != i) {
                sumX += event.getX((int)i);
                sumY += event.getY((int)i);
            }
            ++i;
        }
        int downPointerCount = pointerUp ? count - 1 : count;
        float focusX = sumX / (float)downPointerCount;
        float focusY = sumY / (float)downPointerCount;
        switch (action) {
            case 5: {
                if (!this.mIsMultitouchEnabled) {
                    return;
                }
                this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_MULTIPLE_FINGERS_PRESSING, event, target, context);
                break;
            }
            case 6: {
                this.mStartFocusX = focusX;
                this.mStartFocusY = focusY;
                break;
            }
            case 0: {
                boolean isSingleFinger;
                if (this.mPreviousDownEvent != null) {
                    MotionEvent motionEvent = this.mPreviousDownEvent;
                    if (motionEvent == null) {
                        Intrinsics.throwNpe();
                    }
                    motionEvent.recycle();
                    this.mPreviousDownEvent = null;
                }
                this.mPreviousDownEvent = this.mCurrentDownEvent;
                this.mCurrentDownEvent = MotionEvent.obtain((MotionEvent)event);
                boolean bl = isSingleFinger = downPointerCount == 1;
                if (isSingleFinger || !this.mIsMultitouchEnabled) {
                    boolean hadTapMessage = this.getOwner().getHandler().hasMessages(161);
                    if (hadTapMessage) {
                        this.getOwner().getHandler().removeMessages(161);
                    }
                    if (this.isLongPressEnabled) {
                        this.getOwner().getHandler().removeMessages(162);
                        this.getOwner().getHandler().sendMessageAtTime(this.obtainMessageWithPayload$collage_gesture_detector_release(162, event, target, context), event.getDownTime() + this.mTapTimeout + this.mLongPressTimeout);
                    }
                    this.mStartFocusX = focusX;
                    this.mStartFocusY = focusY;
                    break;
                }
                this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_MULTIPLE_FINGERS_PRESSING, event, target, context);
                break;
            }
            case 2: {
                int deltaX = (int)(focusX - this.mStartFocusX);
                int deltaY = (int)(focusY - this.mStartFocusY);
                int distance = deltaX * deltaX + deltaY * deltaY;
                if ((long)distance <= this.mTouchSlopSquare) break;
                this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_DRAG, event, target, context);
                break;
            }
            case 1: {
                if (this.mCurrentUpEvent != null) {
                    MotionEvent motionEvent = this.mCurrentUpEvent;
                    if (motionEvent == null) {
                        Intrinsics.throwNpe();
                    }
                    motionEvent.recycle();
                }
                this.mCurrentUpEvent = MotionEvent.obtain((MotionEvent)event);
                if (this.mHadLongPress) {
                    this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_IDLE, event, target, context);
                    break;
                }
                if (this.isConsideredCloseTap(this.mPreviousDownEvent, this.mCurrentDownEvent)) {
                    SingleFingerPressingState singleFingerPressingState = this;
                    ++singleFingerPressingState.mTapCount;
                    int cfr_ignored_0 = singleFingerPressingState.mTapCount;
                }
                this.cancelLongPress();
                this.getOwner().getHandler().sendMessageDelayed(this.obtainMessageWithPayload$collage_gesture_detector_release(161, event, target, context), this.mTapTimeout);
                break;
            }
            case 3: {
                this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_IDLE, event, target, context);
            }
        }
    }

    @Override
    public void onExit(@NotNull MotionEvent event, @Nullable Object target, @Nullable Object context) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        int action = event.getActionMasked();
        this.getOwner().getHandler().removeMessages(161);
        if (this.isLongPressEnabled) {
            this.getOwner().getHandler().removeMessages(162);
        }
        if (action == 1) {
            MotionEvent motionEvent = this.mCurrentUpEvent;
            if (motionEvent == null) {
                Intrinsics.throwNpe();
            }
            MyMotionEvent clone = this.obtainMyMotionEvent(motionEvent);
            if (this.isLongPressEnabled && this.mHadLongPress) {
                IGestureListener iGestureListener = this.getOwner().getListener();
                if (iGestureListener != null) {
                    iGestureListener.onLongTap(clone, this.mTouchingObject, this.mTouchingContext);
                }
            } else if (this.isTapEnabled && this.mTapCount > 0) {
                if (this.mTapCount == 1) {
                    IGestureListener iGestureListener = this.getOwner().getListener();
                    if (iGestureListener != null) {
                        iGestureListener.onSingleTap(clone, this.mTouchingObject, this.mTouchingContext);
                    }
                } else if (this.mTapCount == 2) {
                    IGestureListener iGestureListener = this.getOwner().getListener();
                    if (iGestureListener != null) {
                        iGestureListener.onDoubleTap(clone, this.mTouchingObject, this.mTouchingContext);
                    }
                } else {
                    IGestureListener iGestureListener = this.getOwner().getListener();
                    if (iGestureListener != null) {
                        iGestureListener.onMoreTap(clone, this.mTouchingObject, this.mTouchingContext, this.mTapCount);
                    }
                }
            }
        }
        if (this.mPreviousDownEvent != null) {
            MotionEvent motionEvent = this.mPreviousDownEvent;
            if (motionEvent == null) {
                Intrinsics.throwNpe();
            }
            motionEvent.recycle();
            this.mPreviousDownEvent = null;
        }
        if (this.mCurrentDownEvent != null) {
            MotionEvent motionEvent = this.mCurrentDownEvent;
            if (motionEvent == null) {
                Intrinsics.throwNpe();
            }
            motionEvent.recycle();
            this.mCurrentDownEvent = null;
        }
        if (this.mCurrentUpEvent != null) {
            MotionEvent motionEvent = this.mCurrentUpEvent;
            if (motionEvent == null) {
                Intrinsics.throwNpe();
            }
            motionEvent.recycle();
            this.mCurrentUpEvent = null;
        }
    }

    @Override
    public boolean onHandleMessage(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        switch (msg.what) {
            case 162: {
                Object object = msg.obj;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.cardinalblue.gesture.state.BaseGestureState.MyMessagePayload");
                }
                BaseGestureState.MyMessagePayload payload = (BaseGestureState.MyMessagePayload)object;
                this.cancelTaps();
                this.mHadLongPress = true;
                if (this.isLongPressEnabled) {
                    IGestureListener iGestureListener = this.getOwner().getListener();
                    if (iGestureListener != null) {
                        iGestureListener.onLongPress(payload.getEvent(), payload.getTarget(), payload.getContext());
                    }
                }
                return true;
            }
            case 161: {
                MotionEvent motionEvent = this.mCurrentUpEvent;
                if (motionEvent != null) {
                    MotionEvent motionEvent2;
                    MotionEvent event = motionEvent2 = motionEvent;
                    this.getOwner().issueStateTransition(IGestureStateOwner.State.STATE_IDLE, event, this.mTouchingObject, this.mTouchingContext);
                }
                return true;
            }
        }
        return false;
    }

    public final void setIsTransitionToMultiTouchEnabled(boolean enabled) {
        this.mIsMultitouchEnabled = enabled;
    }

    private final boolean isConsideredCloseTap(MotionEvent previousDown, MotionEvent currentDown) {
        int deltaY;
        if (currentDown == null) {
            return false;
        }
        if (previousDown == null) {
            return true;
        }
        int deltaX = (int)currentDown.getX() - (int)previousDown.getX();
        return (long)(deltaX * deltaX + (deltaY = (int)currentDown.getY() - (int)previousDown.getY()) * deltaY) < this.mTapSlopSquare;
    }

    private final void cancelLongPress() {
        this.getOwner().getHandler().removeMessages(162);
        this.mHadLongPress = false;
    }

    private final void cancelTaps() {
        this.getOwner().getHandler().removeMessages(161);
    }

    public SingleFingerPressingState(@NotNull IGestureStateOwner owner, long mTapSlopSquare, long mTouchSlopSquare, long mTapTimeout, long mLongPressTimeout) {
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        super(owner);
        this.mTapSlopSquare = mTapSlopSquare;
        this.mTouchSlopSquare = mTouchSlopSquare;
        this.mTapTimeout = mTapTimeout;
        this.mLongPressTimeout = mLongPressTimeout;
        this.isTapEnabled = true;
        this.isLongPressEnabled = true;
        this.mIsMultitouchEnabled = true;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/cardinalblue/gesture/state/SingleFingerPressingState$Companion;", "", "()V", "MSG_LONG_PRESS", "", "MSG_TAP", "collage-gesture-detector_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

