/*
 * Decompiled with CFR 0.152.
 */
package com.cardinalblue.gesture;

public class MyMotionEvent {
    public final int maskedAction;
    public final int downPointerCount;
    public final float[] downXs;
    public final float[] downYs;
    public final float downFocusX;
    public final float downFocusY;
    public final boolean isUp;
    public final float upX;
    public final float upY;

    public MyMotionEvent(int maskedAction, float[] downXs, float[] downYs, boolean isUp, float upX, float upY) {
        if (downXs == null || downYs == null) {
            throw new IllegalArgumentException("Invalid down x and y array.");
        }
        if (downXs.length != downYs.length) {
            throw new IllegalArgumentException("Amount of down x is not consistent to y.");
        }
        this.maskedAction = maskedAction;
        this.downXs = downXs;
        this.downYs = downYs;
        this.downPointerCount = downXs.length;
        float sumX = 0.0f;
        float sumY = 0.0f;
        for (int i = 0; i < this.downPointerCount; ++i) {
            sumX += downXs[i];
            sumY += downYs[i];
        }
        this.downFocusX = sumX / (float)this.downPointerCount;
        this.downFocusY = sumY / (float)this.downPointerCount;
        this.isUp = isUp;
        this.upX = upX;
        this.upY = upY;
    }
}

