/*
 * Decompiled with CFR 0.152.
 */
package com.cardinalblue.gesture;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.cardinalblue.gesture.GestureDetector$WhenMappings;
import com.cardinalblue.gesture.IGestureListener;
import com.cardinalblue.gesture.IGestureStateOwner;
import com.cardinalblue.gesture.state.BaseGestureState;
import com.cardinalblue.gesture.state.DragState;
import com.cardinalblue.gesture.state.IdleState;
import com.cardinalblue.gesture.state.MultipleFingersPressingState;
import com.cardinalblue.gesture.state.PinchState;
import com.cardinalblue.gesture.state.SingleFingerPressingState;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\u0018\u0000 ;2\u00020\u00012\u00020\u0002:\u0002;<B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J0\u0010,\u001a\u00020-2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J,\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u0001042\b\u0010\u0003\u001a\u0004\u0018\u000104H\u0016J\"\u00105\u001a\u00020)2\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u0001042\b\u0010\u0003\u001a\u0004\u0018\u000104J\u0006\u00106\u001a\u00020-J\u000e\u00107\u001a\u00020-2\u0006\u00108\u001a\u00020)J\u000e\u00109\u001a\u00020-2\u0006\u00108\u001a\u00020)J\u000e\u0010:\u001a\u00020-2\u0006\u00108\u001a\u00020)R\u001b\u0010\u000b\u001a\u00020\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/cardinalblue/gesture/GestureDetector;", "Landroid/os/Handler$Callback;", "Lcom/cardinalblue/gesture/IGestureStateOwner;", "context", "Landroid/content/Context;", "touchSlop", "", "tapSlop", "minFlingVec", "maxFlingVec", "(Landroid/content/Context;FFFF)V", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "handler$delegate", "Lkotlin/Lazy;", "listener", "Lcom/cardinalblue/gesture/IGestureListener;", "getListener", "()Lcom/cardinalblue/gesture/IGestureListener;", "setListener", "(Lcom/cardinalblue/gesture/IGestureListener;)V", "mDragState", "Lcom/cardinalblue/gesture/state/DragState;", "mIdleState", "Lcom/cardinalblue/gesture/state/IdleState;", "mMaxFlingVelocity", "", "mMinFlingVelocity", "mMultipleFingersPressingState", "Lcom/cardinalblue/gesture/state/MultipleFingersPressingState;", "mPinchState", "Lcom/cardinalblue/gesture/state/PinchState;", "mSingleFingerPressingState", "Lcom/cardinalblue/gesture/state/SingleFingerPressingState;", "mState", "Lcom/cardinalblue/gesture/state/BaseGestureState;", "mTapSlopSquare", "mTouchSlopSquare", "handleMessage", "", "msg", "Landroid/os/Message;", "init", "", "issueStateTransition", "newState", "Lcom/cardinalblue/gesture/IGestureStateOwner$State;", "event", "Landroid/view/MotionEvent;", "target", "", "onTouchEvent", "resetConfig", "setIsLongPressEnabled", "enabled", "setIsMultitouchEnabled", "setIsTapEnabled", "Companion", "GestureHandler", "collage-gesture-detector_release"})
public final class GestureDetector
implements Handler.Callback,
IGestureStateOwner {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private int mTouchSlopSquare;
    private int mTapSlopSquare;
    private int mMinFlingVelocity;
    private int mMaxFlingVelocity;
    @Nullable
    private IGestureListener listener;
    @NotNull
    private final Lazy handler$delegate;
    private BaseGestureState mState;
    private final IdleState mIdleState;
    private final SingleFingerPressingState mSingleFingerPressingState;
    private final MultipleFingersPressingState mMultipleFingersPressingState;
    private final DragState mDragState;
    private final PinchState mPinchState;
    private static final int LONG_PRESS_TIMEOUT;
    private static final int TAP_TIMEOUT;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(GestureDetector.class), "handler", "getHandler()Landroid/os/Handler;"))};
        Companion = new Companion(null);
        LONG_PRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
        TAP_TIMEOUT = Math.max(150, ViewConfiguration.getTapTimeout());
    }

    @Override
    @Nullable
    public IGestureListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(@Nullable IGestureListener iGestureListener) {
        this.listener = iGestureListener;
    }

    @Override
    @NotNull
    public Handler getHandler() {
        Lazy lazy = this.handler$delegate;
        GestureDetector gestureDetector = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Handler)lazy.getValue();
    }

    @Override
    public void issueStateTransition(@NotNull IGestureStateOwner.State newState, @NotNull MotionEvent event, @Nullable Object target, @Nullable Object context) {
        BaseGestureState baseGestureState;
        BaseGestureState oldState;
        Intrinsics.checkParameterIsNotNull((Object)((Object)newState), (String)"newState");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        BaseGestureState baseGestureState2 = oldState = this.mState;
        if (baseGestureState2 != null) {
            baseGestureState2.onExit(event, target, context);
        }
        switch (GestureDetector$WhenMappings.$EnumSwitchMapping$0[newState.ordinal()]) {
            case 1: {
                baseGestureState = this.mIdleState;
                break;
            }
            case 2: {
                baseGestureState = this.mSingleFingerPressingState;
                break;
            }
            case 3: {
                baseGestureState = this.mDragState;
                break;
            }
            case 4: {
                baseGestureState = this.mMultipleFingersPressingState;
                break;
            }
            case 5: {
                baseGestureState = this.mPinchState;
                break;
            }
            default: {
                baseGestureState = this.mIdleState;
            }
        }
        BaseGestureState baseGestureState3 = this.mState = baseGestureState;
        if (baseGestureState3 == null) {
            Intrinsics.throwNpe();
        }
        baseGestureState3.onEnter(event, target, context);
    }

    public final void setIsTapEnabled(boolean enabled) {
        this.mSingleFingerPressingState.setTapEnabled(enabled);
    }

    public final void setIsLongPressEnabled(boolean enabled) {
        this.mSingleFingerPressingState.setTapEnabled(enabled);
    }

    public final void setIsMultitouchEnabled(boolean enabled) {
        this.mSingleFingerPressingState.setIsTransitionToMultiTouchEnabled(enabled);
        this.mIdleState.setIsTransitionToMultiTouchEnabled(enabled);
        this.mDragState.setIsTransitionToMultiTouchEnabled(enabled);
    }

    public final void resetConfig() {
        this.mSingleFingerPressingState.setLongPressEnabled(true);
        this.mSingleFingerPressingState.setTapEnabled(true);
        this.mSingleFingerPressingState.setIsTransitionToMultiTouchEnabled(true);
        this.mIdleState.setIsTransitionToMultiTouchEnabled(true);
        this.mDragState.setIsTransitionToMultiTouchEnabled(true);
    }

    public final boolean onTouchEvent(@NotNull MotionEvent event, @Nullable Object target, @Nullable Object context) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        BaseGestureState baseGestureState = this.mState;
        if (baseGestureState == null) {
            Intrinsics.throwNpe();
        }
        baseGestureState.onDoing(event, target, context);
        return this.mSingleFingerPressingState.isTapEnabled() || this.mSingleFingerPressingState.isLongPressEnabled();
    }

    public boolean handleMessage(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        BaseGestureState baseGestureState = this.mState;
        if (baseGestureState == null) {
            Intrinsics.throwNpe();
        }
        return baseGestureState.onHandleMessage(msg);
    }

    private final void init(Context context, float touchSlop, float tapSlop, float minFlingVec, float maxFlingVec) {
        ViewConfiguration configuration;
        ViewConfiguration viewConfiguration = configuration = ViewConfiguration.get((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewConfiguration, (String)"configuration");
        float newTouchSlop = Math.min(touchSlop, (float)viewConfiguration.getScaledTouchSlop());
        float newTapSlop = Math.min(tapSlop, (float)configuration.getScaledDoubleTapSlop());
        this.mTouchSlopSquare = (int)(newTouchSlop * newTouchSlop);
        this.mTapSlopSquare = (int)(newTapSlop * newTapSlop);
        this.mMinFlingVelocity = (int)Math.max(minFlingVec, (float)configuration.getScaledMinimumFlingVelocity());
        this.mMaxFlingVelocity = (int)Math.max(maxFlingVec, (float)configuration.getScaledMaximumFlingVelocity());
    }

    public GestureDetector(@NotNull Context context, float touchSlop, float tapSlop, float minFlingVec, float maxFlingVec) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.handler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GestureHandler>(this){
            final /* synthetic */ GestureDetector this$0;

            @NotNull
            public final GestureHandler invoke() {
                return new GestureHandler(this.this$0);
            }
            {
                this.this$0 = gestureDetector;
                super(0);
            }
        }));
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper()) ^ true) {
            throw (Throwable)new IllegalThreadStateException("The detector should be always initialized on the main thread.");
        }
        this.init(context, touchSlop, tapSlop, minFlingVec, maxFlingVec);
        this.mIdleState = new IdleState(this);
        this.mSingleFingerPressingState = new SingleFingerPressingState(this, this.mTapSlopSquare, this.mTouchSlopSquare, GestureDetector.Companion.getTAP_TIMEOUT(), GestureDetector.Companion.getLONG_PRESS_TIMEOUT());
        this.mMultipleFingersPressingState = new MultipleFingersPressingState(this, this.mTouchSlopSquare);
        this.mDragState = new DragState(this, this.mMinFlingVelocity, this.mMaxFlingVelocity);
        this.mPinchState = new PinchState(this);
        this.mState = this.mIdleState;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/cardinalblue/gesture/GestureDetector$GestureHandler;", "Landroid/os/Handler;", "callback", "Landroid/os/Handler$Callback;", "(Landroid/os/Handler$Callback;)V", "collage-gesture-detector_release"})
    private static final class GestureHandler
    extends Handler {
        public GestureHandler(@NotNull Handler.Callback callback) {
            Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
            super(callback);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/cardinalblue/gesture/GestureDetector$Companion;", "", "()V", "LONG_PRESS_TIMEOUT", "", "getLONG_PRESS_TIMEOUT", "()I", "TAP_TIMEOUT", "getTAP_TIMEOUT", "collage-gesture-detector_release"})
    public static final class Companion {
        private final int getLONG_PRESS_TIMEOUT() {
            return LONG_PRESS_TIMEOUT;
        }

        private final int getTAP_TIMEOUT() {
            return TAP_TIMEOUT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

