/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.migration;

import com.carbonfive.db.jdbc.DatabaseType;
import com.carbonfive.db.migration.Migration;
import com.carbonfive.db.migration.MigrationException;
import com.carbonfive.db.migration.MigrationFactory;
import com.carbonfive.db.migration.MigrationResolver;
import com.carbonfive.db.migration.SimpleVersionExtractor;
import com.carbonfive.db.migration.VersionExtractor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMigrationResolver
implements MigrationResolver {
    private static final String CLASSPATH_MIGRATIONS_SQL = "classpath:/db/migrations/";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String migrationsLocation;
    private VersionExtractor versionExtractor;
    private MigrationFactory migrationFactory = new MigrationFactory();

    public ResourceMigrationResolver() {
        this(CLASSPATH_MIGRATIONS_SQL);
    }

    public ResourceMigrationResolver(String migrationsLocation) {
        this(migrationsLocation, new SimpleVersionExtractor());
    }

    public ResourceMigrationResolver(String migrationsLocation, VersionExtractor versionExtractor) {
        this.setMigrationsLocation(migrationsLocation);
        this.setVersionExtractor(versionExtractor);
    }

    @Override
    public Set<Migration> resolve(DatabaseType dbType) {
        ArrayList<Resource> resources;
        HashSet<Migration> migrations = new HashSet<Migration>();
        String convertedMigrationsLocation = this.convertMigrationsLocation(this.migrationsLocation, dbType);
        PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
        try {
            resources = new ArrayList<Resource>(Arrays.asList(patternResolver.getResources(convertedMigrationsLocation)));
        }
        catch (IOException e) {
            throw new MigrationException(e);
        }
        CollectionUtils.filter(resources, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                try {
                    return ((Resource)object).isReadable() && !((Resource)object).getFilename().startsWith(".");
                }
                catch (Exception e) {
                    if (ResourceMigrationResolver.this.logger.isDebugEnabled()) {
                        ResourceMigrationResolver.this.logger.debug("Exception while filtering resource.", (Throwable)e);
                    }
                    return false;
                }
            }
        });
        if (resources.isEmpty()) {
            String message = "No migrations were found using resource pattern '" + this.migrationsLocation + "'.";
            this.logger.error(message);
            throw new MigrationException(message);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Found " + resources.size() + " resources: " + StringUtils.collectionToCommaDelimitedString(resources));
        }
        for (Resource resource : resources) {
            String version = this.versionExtractor.extractVersion(resource.getFilename());
            if (CollectionUtils.find(migrations, (Predicate)new Migration.MigrationVersionPredicate(version)) != null) {
                String message = "Non-unique migration version.";
                this.logger.error(message);
                throw new MigrationException(message);
            }
            migrations.add(this.migrationFactory.create(version, resource));
        }
        return migrations;
    }

    @Override
    public Set<Migration> resolve() {
        return this.resolve(DatabaseType.UNKNOWN);
    }

    protected String convertMigrationsLocation(String migrationsLocation, DatabaseType dbType) {
        String converted = migrationsLocation;
        if (!org.apache.commons.lang.StringUtils.isBlank((String)FilenameUtils.getName((String)converted)) && !FilenameUtils.getName((String)converted).contains("*")) {
            converted = converted + "/";
        }
        if (!FilenameUtils.getName((String)converted).contains("*")) {
            converted = converted + "*";
        }
        if (!converted.startsWith("file:") && !converted.startsWith("classpath:")) {
            converted = "file:" + converted;
        }
        return converted;
    }

    public void setMigrationsLocation(String migrationsLocation) {
        this.migrationsLocation = migrationsLocation;
    }

    public void setVersionExtractor(VersionExtractor versionExtractor) {
        this.versionExtractor = versionExtractor;
    }

    public void setMigrationFactory(MigrationFactory migrationFactory) {
        this.migrationFactory = migrationFactory;
    }
}

