/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.migration;

import com.carbonfive.db.jdbc.DatabaseType;
import com.carbonfive.db.jdbc.DatabaseUtils;
import com.carbonfive.db.migration.Migration;
import com.carbonfive.db.migration.MigrationException;
import com.carbonfive.db.migration.MigrationManager;
import com.carbonfive.db.migration.MigrationResolver;
import com.carbonfive.db.migration.ResourceMigrationResolver;
import com.carbonfive.db.migration.SimpleVersionStrategy;
import com.carbonfive.db.migration.VersionStrategy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceMigrationManager
implements MigrationManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JdbcTemplate jdbcTemplate;
    private DatabaseType dbType;
    private VersionStrategy versionStrategy = new SimpleVersionStrategy();
    private MigrationResolver migrationResolver = new ResourceMigrationResolver();

    public DataSourceMigrationManager(DataSource dataSource) {
        this(dataSource, DatabaseType.UNKNOWN);
        this.dbType = this.determineDatabaseType();
    }

    public DataSourceMigrationManager(DataSource dataSource, DatabaseType dbType) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.dbType = dbType;
    }

    @Override
    public boolean validate() {
        return this.pendingMigrations().isEmpty();
    }

    @Override
    public SortedSet<Migration> pendingMigrations() {
        Set<String> appliedMigrations = this.determineAppliedMigrationVersions();
        Set<Migration> availableMigrations = this.migrationResolver.resolve(this.dbType);
        TreeSet<Migration> pendingMigrations = new TreeSet<Migration>();
        CollectionUtils.select(availableMigrations, (Predicate)new PendingMigrationPredicate(appliedMigrations), pendingMigrations);
        return pendingMigrations;
    }

    @Override
    public void migrate() {
        SortedSet<Migration> pendingMigrations;
        if (!this.isMigrationsEnabled()) {
            this.enableMigrations();
        }
        if ((pendingMigrations = this.pendingMigrations()).isEmpty()) {
            this.logger.info("Database is up to date; no migration necessary.");
            return;
        }
        StopWatch watch = new StopWatch();
        watch.start();
        this.logger.info("Migrating database... applying " + pendingMigrations.size() + " migration" + (pendingMigrations.size() > 1 ? "s" : "") + ".");
        try {
            this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

                public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                    Migration currentMigration = null;
                    boolean autoCommit = connection.getAutoCommit();
                    connection.setAutoCommit(false);
                    try {
                        Iterator i$ = pendingMigrations.iterator();
                        while (i$.hasNext()) {
                            Migration migration;
                            currentMigration = migration = (Migration)i$.next();
                            DataSourceMigrationManager.this.logger.info("Running migration " + currentMigration.getFilename() + ".");
                            Date startTime = new Date();
                            StopWatch migrationWatch = new StopWatch();
                            migrationWatch.start();
                            currentMigration.migrate(DataSourceMigrationManager.this.dbType, connection);
                            DataSourceMigrationManager.this.versionStrategy.recordMigration(DataSourceMigrationManager.this.dbType, connection, currentMigration.getVersion(), startTime, migrationWatch.getTime());
                            connection.commit();
                        }
                    }
                    catch (Throwable e) {
                        assert (currentMigration != null);
                        String message = "Migration for version " + currentMigration.getVersion() + " failed, rolling back and terminating migration.";
                        DataSourceMigrationManager.this.logger.error(message, e);
                        connection.rollback();
                        throw new MigrationException(message, e);
                    }
                    finally {
                        connection.setAutoCommit(autoCommit);
                    }
                    return null;
                }
            });
        }
        catch (DataAccessException e) {
            this.logger.error("Failed to migrate database.", (Throwable)e);
            throw new MigrationException(e);
        }
        watch.stop();
        this.logger.info("Migrated database in " + DurationFormatUtils.formatDurationHMS((long)watch.getTime()) + ".");
    }

    public void setDatabaseType(DatabaseType dbType) {
        this.dbType = dbType;
    }

    public void setMigrationResolver(MigrationResolver migrationResolver) {
        this.migrationResolver = migrationResolver;
    }

    public void setVersionStrategy(VersionStrategy versionStrategy) {
        this.versionStrategy = versionStrategy;
    }

    protected DatabaseType determineDatabaseType() {
        return (DatabaseType)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<DatabaseType>(){

            public DatabaseType doInConnection(Connection connection) throws SQLException, DataAccessException {
                return DatabaseUtils.databaseType((String)connection.getMetaData().getURL());
            }
        });
    }

    protected boolean isMigrationsEnabled() {
        try {
            return (Boolean)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Boolean>(){

                public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                    return DataSourceMigrationManager.this.versionStrategy.isEnabled(DataSourceMigrationManager.this.dbType, connection);
                }
            });
        }
        catch (DataAccessException e) {
            this.logger.error("Could not enable migrations.", (Throwable)e);
            throw new MigrationException(e);
        }
    }

    protected void enableMigrations() {
        try {
            this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

                public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                    DataSourceMigrationManager.this.versionStrategy.enableVersioning(DataSourceMigrationManager.this.dbType, connection);
                    return null;
                }
            });
            this.logger.info("Successfully enabled migrations.");
        }
        catch (DataAccessException e) {
            this.logger.error("Could not enable migrations.", (Throwable)e);
            throw new MigrationException(e);
        }
    }

    protected Set<String> determineAppliedMigrationVersions() {
        return (Set)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Set<String>>(){

            public Set<String> doInConnection(Connection connection) throws SQLException, DataAccessException {
                return DataSourceMigrationManager.this.versionStrategy.appliedMigrations(DataSourceMigrationManager.this.dbType, connection);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PendingMigrationPredicate
    implements Predicate {
        private final Set<String> appliedMigrations;

        public PendingMigrationPredicate(Set<String> appliedMigrations) {
            this.appliedMigrations = appliedMigrations == null ? new HashSet() : appliedMigrations;
        }

        public boolean evaluate(Object input) {
            if (input instanceof Migration) {
                return !this.appliedMigrations.contains(((Migration)input).getVersion());
            }
            return !this.appliedMigrations.contains(input.toString());
        }
    }
}

