/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.migration.maven;

import com.carbonfive.db.migration.DriverManagerMigrationManager;
import com.carbonfive.db.migration.Migration;
import com.carbonfive.db.migration.maven.AbstractMigrationMojo;
import java.util.SortedSet;
import org.apache.maven.plugin.MojoExecutionException;

public class ValidateMojo
extends AbstractMigrationMojo {
    public void executeMojo() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Validating " + this.getUrl() + " using migrations at " + this.getMigrationsPath() + "."));
        try {
            DriverManagerMigrationManager manager = this.createMigrationManager();
            SortedSet pendingMigrations = manager.pendingMigrations();
            StringBuilder sb = new StringBuilder();
            sb.append("\n            Database: ").append(this.getUrl());
            sb.append("\n          Up-to-date: ").append(pendingMigrations.isEmpty());
            sb.append("\n  Pending Migrations: ");
            if (!pendingMigrations.isEmpty()) {
                boolean first = true;
                for (Migration migration : pendingMigrations) {
                    if (!first) {
                        sb.append("\n                      ");
                    }
                    first = false;
                    sb.append(migration.getFilename());
                }
            }
            this.getLog().info((CharSequence)sb.toString());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to validate " + this.getUrl(), e);
        }
    }
}

