/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.migration.maven;

import com.carbonfive.db.jdbc.schema.CreateDatabase;
import com.carbonfive.db.jdbc.schema.DropDatabase;
import com.carbonfive.db.migration.maven.AbstractMigrationMojo;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class ResetMojo
extends AbstractMigrationMojo {
    public void executeMojo() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Resetting database " + this.getUrl() + "."));
        try {
            this.getLog().info((CharSequence)("Dropping database " + this.getUrl() + "."));
            String dropSql = StringUtils.isBlank((String)this.getDropSql()) ? "drop database %s" : this.getDropSql();
            new DropDatabase(this.getDriver(), this.getUrl(), this.getUsername(), this.getPassword()).execute(dropSql);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Failed to reset database " + this.getUrl(), (Exception)e);
        }
        catch (SQLException ignored) {
            // empty catch block
        }
        try {
            this.getLog().info((CharSequence)("Creating database " + this.getUrl() + "."));
            String createSql = StringUtils.isBlank((String)this.getCreateSql()) ? "create database %s" : this.getCreateSql();
            new CreateDatabase(this.getDriver(), this.getUrl(), this.getUsername(), this.getPassword()).execute(createSql);
            this.getLog().info((CharSequence)("Migrating database " + this.getUrl() + "."));
            this.createMigrationManager().migrate();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to reset database " + this.getUrl(), e);
        }
    }
}

