/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.migration.maven;

import com.carbonfive.db.migration.maven.AbstractMigrationMojo;
import java.io.File;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.maven.plugin.MojoExecutionException;

public class NewMojo
extends AbstractMigrationMojo {
    private String versionPattern = "yyyyMMddHHmmss";
    private String versionTimeZone = "UTC";
    private String migrationExtension = ".sql";

    public void executeMojo() throws MojoExecutionException {
        String directory = this.getMigrationsPath();
        if ((directory = StringUtils.remove((String)directory, (String)"file:")).startsWith("classpath:")) {
            if ((directory = StringUtils.remove((String)directory, (String)"classpath:")).startsWith("/") || directory.startsWith("\"")) {
                directory = StringUtils.substring((String)directory, (int)1);
            }
            directory = "src/main/resources/" + directory;
        }
        if (!directory.startsWith("/") && !directory.startsWith("\"")) {
            directory = this.project.getBasedir().getAbsolutePath() + "/" + directory;
        }
        if (directory.endsWith("*.sql") || directory.endsWith("*.*") || directory.endsWith("*.groovy") || directory.endsWith("*")) {
            directory = FilenameUtils.getFullPath((String)directory);
        }
        if (!directory.endsWith("/") && !directory.endsWith("\"")) {
            directory = directory + "/";
        }
        directory = FilenameUtils.separatorsToUnix((String)FilenameUtils.getFullPath((String)directory));
        try {
            new File(directory).mkdirs();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create migrations directory: " + directory, e);
        }
        StringBuffer sb = new StringBuffer(FastDateFormat.getInstance((String)this.getVersionPattern(), (TimeZone)TimeZone.getTimeZone(this.versionTimeZone)).format(new Date()));
        String name = System.getProperty("name", "");
        if (StringUtils.isNotBlank((String)name)) {
            sb.append("_").append(name);
        }
        sb.append(this.getMigrationExtension());
        String filename = directory + sb.toString();
        this.getLog().info((CharSequence)("Creating new migration " + filename + "."));
        try {
            new File(filename).createNewFile();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create migration file: " + filename, e);
        }
    }

    public String getVersionPattern() {
        return this.versionPattern;
    }

    public void setVersionTimeZone(String versionTimeZone) {
        this.versionTimeZone = versionTimeZone;
    }

    public String getMigrationExtension() {
        return this.migrationExtension;
    }
}

