/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.migration.maven;

import com.carbonfive.db.migration.DriverManagerMigrationManager;
import com.carbonfive.db.migration.Migration;
import com.carbonfive.db.migration.maven.AbstractMigrationMojo;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.SortedSet;
import org.apache.maven.plugin.MojoExecutionException;

public class CheckMojo
extends AbstractMigrationMojo {
    public void executeMojo() throws MojoExecutionException {
        SortedSet pendingMigrations;
        this.getLog().info((CharSequence)("Checking " + this.getUrl() + " using migrations at " + this.getMigrationsPath() + "."));
        try {
            DriverManagerMigrationManager manager = this.createMigrationManager();
            pendingMigrations = manager.pendingMigrations();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to check " + this.getUrl(), e);
        }
        if (pendingMigrations.isEmpty()) {
            return;
        }
        Collection pendingMigrationsNames = Collections2.transform((Collection)pendingMigrations, (Function)new Function<Migration, String>(){

            public String apply(Migration migration) {
                return migration.getFilename();
            }
        });
        String msg = String.format("There %s %d pending migrations: \n\n    %s\n\n    Run db-migration:migrate to apply pending migrations.", pendingMigrations.size() == 1 ? "is" : "are", pendingMigrations.size(), Joiner.on((String)"\n    ").join((Iterable)pendingMigrationsNames));
        this.getLog().warn((CharSequence)msg);
        throw new MojoExecutionException(String.format("There %s %d pending migrations, migrate your db and try again.", pendingMigrations.size() == 1 ? "is" : "are", pendingMigrations.size()));
    }
}

