/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.migration.maven;

import com.carbonfive.db.jdbc.DatabaseType;
import com.carbonfive.db.jdbc.DatabaseUtils;
import com.carbonfive.db.migration.DriverManagerMigrationManager;
import com.carbonfive.db.migration.MigrationResolver;
import com.carbonfive.db.migration.ResourceMigrationResolver;
import com.carbonfive.db.migration.SimpleVersionStrategy;
import com.carbonfive.db.migration.VersionStrategy;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractMigrationMojo
extends AbstractMojo {
    protected MavenProject project;
    private String url;
    private String driver;
    private String username;
    private String password = "";
    private String databaseType;
    private String migrationsPath = "src/main/db/migrations/";
    private String versionTable;
    private String versionColumn;
    private String appliedDateColumn;
    private String durationColumn;
    private String createSql;
    private String dropSql;

    public abstract void executeMojo() throws MojoExecutionException;

    public final void execute() throws MojoExecutionException {
        if (StringUtils.isBlank((String)this.url) && StringUtils.isBlank((String)this.username)) {
            return;
        }
        String string = this.password = StringUtils.isBlank((String)this.password) ? "" : this.password;
        if (StringUtils.isBlank((String)this.driver)) {
            this.driver = DatabaseUtils.driverClass((String)this.url);
        }
        if (this.databaseType == null) {
            this.databaseType = DatabaseUtils.databaseType((String)this.url).toString();
        }
        this.validateConfiguration();
        this.executeMojo();
    }

    protected void validateConfiguration() throws MojoExecutionException {
        if (StringUtils.isBlank((String)this.driver)) {
            throw new MojoExecutionException("No database driver. Specify one in the plugin configuration.");
        }
        if (StringUtils.isBlank((String)this.url)) {
            throw new MojoExecutionException("No database url. Specify one in the plugin configuration.");
        }
        if (StringUtils.isBlank((String)this.username)) {
            throw new MojoExecutionException("No database username. Specify one in the plugin configuration.");
        }
        try {
            DatabaseType.valueOf((String)this.databaseType);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException("Database type of '" + this.databaseType + "' is invalid.  Valid values: " + org.springframework.util.StringUtils.arrayToDelimitedString((Object[])DatabaseType.values(), (String)", "));
        }
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Can't load driver class " + this.driver + ". Be sure to include it as a plugin dependency.");
        }
    }

    public DriverManagerMigrationManager createMigrationManager() {
        DriverManagerMigrationManager manager = new DriverManagerMigrationManager(this.driver, this.url, this.username, this.password, DatabaseType.valueOf((String)this.databaseType));
        String path = this.migrationsPath;
        if (path.startsWith("file:")) {
            path = StringUtils.substring((String)path, (int)5);
        }
        if (!(path.startsWith("classpath:") || path.startsWith("\"") || path.startsWith("/"))) {
            path = this.project.getBasedir().getAbsolutePath() + "/" + path;
        }
        path = FilenameUtils.separatorsToUnix((String)path);
        manager.setMigrationResolver((MigrationResolver)new ResourceMigrationResolver(path));
        SimpleVersionStrategy strategy = new SimpleVersionStrategy();
        strategy.setVersionTable(StringUtils.defaultIfEmpty((String)this.versionTable, (String)"schema_version"));
        strategy.setVersionColumn(StringUtils.defaultIfEmpty((String)this.versionColumn, (String)"version"));
        strategy.setAppliedDateColumn(StringUtils.defaultIfEmpty((String)this.appliedDateColumn, (String)"applied_on"));
        strategy.setDurationColumn(StringUtils.defaultIfEmpty((String)this.durationColumn, (String)"duration"));
        manager.setVersionStrategy((VersionStrategy)strategy);
        return manager;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getMigrationsPath() {
        return this.migrationsPath;
    }

    public String getVersionTable() {
        return this.versionTable;
    }

    public String getVersionColumn() {
        return this.versionColumn;
    }

    public String getAppliedDateColumn() {
        return this.appliedDateColumn;
    }

    public String getDurationColumn() {
        return this.durationColumn;
    }

    public String getCreateSql() {
        return this.createSql;
    }

    public String getDropSql() {
        return this.dropSql;
    }
}

