/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.jdbc.schema;

import com.carbonfive.db.jdbc.DatabaseUtils;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.springframework.beans.BeanUtils;

abstract class AbstractSchemaCommand {
    private String driver;
    private String url;
    private String username;
    private String password;

    public AbstractSchemaCommand(String url, String username, String password) {
        this(DatabaseUtils.driverClass(url), url, username, password);
    }

    public AbstractSchemaCommand(String driver, String url, String username, String password) {
        this.driver = driver;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public abstract void execute() throws SQLException, ClassNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String createSql) throws SQLException, ClassNotFoundException {
        String serverUrl = DatabaseUtils.extractServerUrl(this.url);
        String databaseName = DatabaseUtils.extractDatabaseName(this.url);
        switch (DatabaseUtils.databaseType(this.url)) {
            case MYSQL: {
                databaseName = "`" + databaseName + "`";
                break;
            }
            case SQL_SERVER: 
            case POSTGRESQL: {
                databaseName = "\"" + databaseName + "\"";
            }
        }
        Driver driver = (Driver)BeanUtils.instantiateClass(Class.forName(this.driver));
        Properties properties = new Properties();
        properties.put("user", this.username);
        properties.put("password", this.password);
        Connection connection = driver.connect(serverUrl, properties);
        try {
            Statement statement = connection.createStatement();
            statement.execute(String.format(createSql, databaseName));
            statement.close();
        }
        finally {
            connection.close();
        }
    }
}

