/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.jdbc.datasource;

import com.carbonfive.db.jdbc.datasource.DataSourceCreationException;
import com.carbonfive.db.jdbc.datasource.DataSourceFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.AbstractDataSource;

public abstract class RoutingDataSource
extends AbstractDataSource {
    private boolean createNewDataSources = true;
    private Map<Object, DataSource> dataSources = new HashMap<Object, DataSource>();
    private DataSourceFactory dataSourceFactory;

    public RoutingDataSource() {
    }

    public RoutingDataSource(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    public void setCreateNewDataSources(boolean createNewDataSources) {
        this.createNewDataSources = createNewDataSources;
    }

    public Connection getConnection() throws SQLException {
        DataSource dataSource = this.findDataSource();
        return dataSource.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        DataSource dataSource = this.findDataSource();
        return dataSource.getConnection(username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource findDataSource() {
        String lookupKey = this.determineCurrentDataSourceKey();
        RoutingDataSource routingDataSource = this;
        synchronized (routingDataSource) {
            if (!this.dataSources.containsKey(lookupKey)) {
                if (!this.createNewDataSources) {
                    throw new RuntimeException();
                }
                this.createDataSource(lookupKey);
            }
        }
        return this.dataSources.get(lookupKey);
    }

    protected DataSource createDataSource(Object lookupKey) throws DataSourceCreationException {
        DataSource dataSource = this.dataSourceFactory.createDataSource(lookupKey);
        this.dataSources.put(lookupKey, dataSource);
        return dataSource;
    }

    protected abstract String determineCurrentDataSourceKey();
}

