/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.hibernate.usertypes;

import com.carbonfive.db.hibernate.usertypes.EnhancedEnum;
import com.carbonfive.db.hibernate.usertypes.EnumUserType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedEnumUserType
extends EnumUserType {
    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String code = rs.getString(names[0]);
        return rs.wasNull() ? null : EnhancedEnumUserType.findByCode(this.enumClass, code);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 12);
        } else {
            st.setString(index, ((EnhancedEnum)value).getCode());
        }
    }

    public static EnhancedEnum findByCode(Class<? extends EnhancedEnum> enumClazz, String code) {
        for (EnhancedEnum e : enumClazz.getEnumConstants()) {
            if (!e.getCode().equals(code)) continue;
            return e;
        }
        throw new IllegalArgumentException("EnhancedEnum with code '" + code + "' does not exist.");
    }
}

