/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.migration;

import com.carbonfive.db.migration.GroovyMigration;
import com.carbonfive.db.migration.Migration;
import com.carbonfive.db.migration.MigrationException;
import com.carbonfive.db.migration.SQLScriptMigration;
import org.apache.commons.io.FilenameUtils;
import org.springframework.core.io.Resource;

public class MigrationFactory {
    public Migration create(String version, Resource resource) {
        String extension = FilenameUtils.getExtension((String)resource.getFilename()).toLowerCase();
        if ("sql".equals(extension)) {
            return new SQLScriptMigration(version, resource);
        }
        if ("groovy".equals(extension)) {
            return new GroovyMigration(version, resource);
        }
        throw new MigrationException("Can't determine migration type for " + resource);
    }
}

