/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.migration;

import com.carbonfive.db.jdbc.DatabaseType;
import com.carbonfive.db.jdbc.DatabaseUtils;
import com.carbonfive.db.migration.Migration;
import com.carbonfive.db.migration.MigrationException;
import com.carbonfive.db.migration.MigrationManager;
import com.carbonfive.db.migration.MigrationResolver;
import com.carbonfive.db.migration.ResourceMigrationResolver;
import com.carbonfive.db.migration.SimpleVersionStrategy;
import com.carbonfive.db.migration.VersionStrategy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceMigrationManager
implements MigrationManager {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private JdbcTemplate jdbcTemplate;
    private DatabaseType dbType;
    private VersionStrategy versionStratgey = new SimpleVersionStrategy();
    private MigrationResolver migrationResolver = new ResourceMigrationResolver();

    public DataSourceMigrationManager(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.dbType = this.determineDatabaseType();
    }

    public DataSourceMigrationManager(DataSource dataSource, DatabaseType dbType) {
        this(dataSource);
        this.dbType = dbType;
    }

    protected void enableMigrations() {
        try {
            this.jdbcTemplate.execute(new ConnectionCallback(){

                public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                    DataSourceMigrationManager.this.versionStratgey.enableVersioning(DataSourceMigrationManager.this.dbType, connection);
                    return null;
                }
            });
            this.log.info("Successfully enabled migrations.");
        }
        catch (DataAccessException e) {
            this.log.error("Could not enable migrations.", (Throwable)e);
            throw new MigrationException(e);
        }
    }

    @Override
    public boolean validate() {
        return this.pendingMigrations().isEmpty();
    }

    @Override
    public SortedSet<String> pendingMigrations() {
        Set<String> appliedMigrations = this.determineAppliedMigrationVersions();
        Set<Migration> availableMigrations = this.migrationResolver.resolve();
        CollectionUtils.transform(availableMigrations, (Transformer)new Transformer(){

            public Object transform(Object o) {
                return ((Migration)o).getVersion();
            }
        });
        TreeSet<String> pendingMigrations = new TreeSet<String>();
        CollectionUtils.select(availableMigrations, (Predicate)new PendingMigrationPredicate(appliedMigrations), pendingMigrations);
        return pendingMigrations;
    }

    @Override
    public void migrate() {
        Set appliedMigrations = this.determineAppliedMigrationVersions();
        if (appliedMigrations == null) {
            this.enableMigrations();
            appliedMigrations = Collections.EMPTY_SET;
        }
        Set<Migration> availableMigrations = this.migrationResolver.resolve();
        final ArrayList pendingMigrations = new ArrayList(availableMigrations.size());
        CollectionUtils.select(availableMigrations, (Predicate)new PendingMigrationPredicate(appliedMigrations), pendingMigrations);
        Collections.sort(pendingMigrations);
        if (pendingMigrations.isEmpty()) {
            this.log.info("Database is up to date; no migration necessary.");
            return;
        }
        StopWatch watch = new StopWatch();
        watch.start();
        this.log.info("Migrating database... applying " + pendingMigrations.size() + " migration" + (pendingMigrations.size() > 1 ? "s" : "") + ".");
        try {
            this.jdbcTemplate.execute(new ConnectionCallback(){

                public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                    int successfulCount = 0;
                    Migration currentMigration = null;
                    boolean autoCommit = connection.getAutoCommit();
                    connection.setAutoCommit(false);
                    try {
                        Iterator i$ = pendingMigrations.iterator();
                        while (i$.hasNext()) {
                            Migration migration;
                            currentMigration = migration = (Migration)i$.next();
                            DataSourceMigrationManager.this.log.info("Running migration version " + currentMigration.getVersion() + ".");
                            Date startTime = new Date();
                            StopWatch migrationWatch = new StopWatch();
                            migrationWatch.start();
                            currentMigration.migrate(DataSourceMigrationManager.this.dbType, connection);
                            DataSourceMigrationManager.this.versionStratgey.recordMigration(DataSourceMigrationManager.this.dbType, connection, currentMigration.getVersion(), startTime, migrationWatch.getTime());
                            connection.commit();
                            ++successfulCount;
                        }
                    }
                    catch (Throwable e) {
                        assert (currentMigration != null);
                        String message = "Migration for version " + currentMigration.getVersion() + " failed, rolling back and terminating migration.";
                        DataSourceMigrationManager.this.log.error(message, e);
                        connection.rollback();
                        throw new MigrationException(message, e);
                    }
                    finally {
                        connection.setAutoCommit(autoCommit);
                    }
                    return successfulCount;
                }
            });
        }
        catch (DataAccessException e) {
            this.log.error("Failed to migrate database.", (Throwable)e);
            throw new MigrationException(e);
        }
        watch.stop();
        this.log.info("Migrated database in " + DurationFormatUtils.formatDurationHMS((long)watch.getTime()) + ".");
    }

    public void setDatabaseType(DatabaseType dbType) {
        this.dbType = dbType;
    }

    public void setMigrationResolver(MigrationResolver migrationResolver) {
        this.migrationResolver = migrationResolver;
    }

    public void setVersionStratgey(VersionStrategy versionStratgey) {
        this.versionStratgey = versionStratgey;
    }

    private DatabaseType determineDatabaseType() {
        return (DatabaseType)this.jdbcTemplate.execute(new ConnectionCallback(){

            public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                return DatabaseUtils.databaseType((String)connection.getMetaData().getURL());
            }
        });
    }

    private Set<String> determineAppliedMigrationVersions() {
        return (Set)this.jdbcTemplate.execute(new ConnectionCallback(){

            public Object doInConnection(Connection connection) throws SQLException, DataAccessException {
                return DataSourceMigrationManager.this.versionStratgey.appliedMigrations(DataSourceMigrationManager.this.dbType, connection);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PendingMigrationPredicate
    implements Predicate {
        private final Set<String> appliedMigrations;

        public PendingMigrationPredicate(Set<String> appliedMigrations) {
            this.appliedMigrations = appliedMigrations == null ? Collections.EMPTY_SET : appliedMigrations;
        }

        public boolean evaluate(Object input) {
            if (input instanceof Migration) {
                return !this.appliedMigrations.contains(((Migration)input).getVersion());
            }
            return !this.appliedMigrations.contains(input.toString());
        }
    }
}

