/*
 * Decompiled with CFR 0.152.
 */
package com.caption.netmonitorlibrary.netStateLib;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import com.caption.netmonitorlibrary.netStateLib.NetChangeObserver;
import com.caption.netmonitorlibrary.netStateLib.NetUtils;
import java.util.ArrayList;

public class NetStateReceiver
extends BroadcastReceiver {
    public static final String CUSTOM_ANDROID_NET_CHANGE_ACTION = "com.zhanyun.api.netstatus.CONNECTIVITY_CHANGE";
    private static final String ANDROID_NET_CHANGE_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";
    private static final String TAG = NetStateReceiver.class.getSimpleName();
    private static boolean isNetAvailable = false;
    private static NetUtils.NetType mNetType;
    private static ArrayList<NetChangeObserver> mNetChangeObservers;
    private static BroadcastReceiver mBroadcastReceiver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BroadcastReceiver getReceiver() {
        if (null != mBroadcastReceiver) return mBroadcastReceiver;
        Class<NetStateReceiver> clazz = NetStateReceiver.class;
        synchronized (NetStateReceiver.class) {
            if (null != mBroadcastReceiver) return mBroadcastReceiver;
            mBroadcastReceiver = new NetStateReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mBroadcastReceiver;
        }
    }

    public void onReceive(Context context, Intent intent) {
        mBroadcastReceiver = this;
        if (intent.getAction().equalsIgnoreCase(ANDROID_NET_CHANGE_ACTION) || intent.getAction().equalsIgnoreCase(CUSTOM_ANDROID_NET_CHANGE_ACTION)) {
            if (!NetUtils.isNetworkAvailable(context)) {
                Log.e((String)((Object)((Object)this)).getClass().getName(), (String)"<--- network disconnected --->");
                isNetAvailable = false;
            } else {
                Log.e((String)((Object)((Object)this)).getClass().getName(), (String)"<--- network connected --->");
                isNetAvailable = true;
                mNetType = NetUtils.getAPNType(context);
            }
            this.notifyObserver();
        }
    }

    public static void registerNetworkStateReceiver(Context mContext) {
        IntentFilter filter = new IntentFilter();
        filter.addAction(CUSTOM_ANDROID_NET_CHANGE_ACTION);
        filter.addAction(ANDROID_NET_CHANGE_ACTION);
        mContext.getApplicationContext().registerReceiver(NetStateReceiver.getReceiver(), filter);
    }

    public static void checkNetworkState(Context mContext) {
        Intent intent = new Intent();
        intent.setAction(CUSTOM_ANDROID_NET_CHANGE_ACTION);
        mContext.sendBroadcast(intent);
    }

    public static void unRegisterNetworkStateReceiver(Context mContext) {
        if (mBroadcastReceiver != null) {
            try {
                mContext.getApplicationContext().unregisterReceiver(mBroadcastReceiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isNetworkAvailable() {
        return isNetAvailable;
    }

    public static NetUtils.NetType getAPNType() {
        return mNetType;
    }

    private void notifyObserver() {
        if (!mNetChangeObservers.isEmpty()) {
            int size = mNetChangeObservers.size();
            for (int i = 0; i < size; ++i) {
                NetChangeObserver observer = mNetChangeObservers.get(i);
                if (observer == null) continue;
                if (NetStateReceiver.isNetworkAvailable()) {
                    observer.onNetConnected(mNetType);
                    continue;
                }
                observer.onNetDisConnect();
            }
        }
    }

    public static void registerObserver(NetChangeObserver observer) {
        if (mNetChangeObservers == null) {
            mNetChangeObservers = new ArrayList();
        }
        mNetChangeObservers.add(observer);
    }

    public static void removeRegisterObserver(NetChangeObserver observer) {
        if (mNetChangeObservers != null && mNetChangeObservers.contains(observer)) {
            mNetChangeObservers.remove(observer);
        }
    }

    static {
        mNetChangeObservers = new ArrayList();
    }
}

