/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetUniConsumer;
import com.caoccao.javet.interfaces.IJavetUniIndexedConsumer;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueIterator;
import com.caoccao.javet.values.reference.IV8ValueSet;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.virtual.V8VirtualValue;
import java.util.Objects;

public class V8ValueSet
extends V8ValueObject
implements IV8ValueSet {
    protected static final String FUNCTION_ENTRIES = "entries";
    protected static final String FUNCTION_KEYS = "keys";

    V8ValueSet(V8Runtime v8Runtime, long handle) throws JavetException {
        super(v8Runtime, handle);
    }

    @Override
    public void add(Object key) throws JavetException {
        try (V8VirtualValue virtualValue = new V8VirtualValue(this.checkV8Runtime(), null, key);){
            this.v8Runtime.getV8Internal().setAdd(this, (V8Value)virtualValue.get());
        }
    }

    @Override
    public boolean delete(Object key) throws JavetException {
        try (V8VirtualValue virtualKey = new V8VirtualValue(this.checkV8Runtime(), OBJECT_CONVERTER, Objects.requireNonNull(key));){
            boolean bl = this.v8Runtime.getV8Internal().setDelete(this, (V8Value)virtualKey.get());
            return bl;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <Key extends V8Value, E extends Throwable> int forEach(IJavetUniConsumer<Key, E> consumer) throws JavetException, E {
        Objects.requireNonNull(consumer);
        int count = 0;
        try (IV8ValueIterator<V8Value> iterator = this.getKeys();){
            Throwable throwable;
            V8Value key;
            while (true) {
                block27: {
                    block25: {
                        block26: {
                            key = iterator.getNext();
                            throwable = null;
                            if (key != null) break block25;
                            if (key == null) return count;
                            if (throwable == null) break block26;
                            try {
                                key.close();
                                return count;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return count;
                            }
                        }
                        key.close();
                        return count;
                    }
                    consumer.accept(key);
                    ++count;
                    if (key == null) continue;
                    if (throwable == null) break block27;
                    try {
                        key.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                key.close();
            }
            catch (Throwable throwable4) {
                try {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (key == null) throw throwable5;
                    if (throwable != null) {
                        try {
                            key.close();
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                            throw throwable5;
                        }
                    }
                    key.close();
                    throw throwable5;
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <Key extends V8Value, E extends Throwable> int forEach(IJavetUniIndexedConsumer<Key, E> consumer) throws JavetException, E {
        Objects.requireNonNull(consumer);
        int count = 0;
        try (IV8ValueIterator<V8Value> iterator = this.getKeys();){
            Throwable throwable;
            V8Value key;
            while (true) {
                block27: {
                    block25: {
                        block26: {
                            key = iterator.getNext();
                            throwable = null;
                            if (key != null) break block25;
                            if (key == null) return count;
                            if (throwable == null) break block26;
                            try {
                                key.close();
                                return count;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return count;
                            }
                        }
                        key.close();
                        return count;
                    }
                    consumer.accept(count, key);
                    ++count;
                    if (key == null) continue;
                    if (throwable == null) break block27;
                    try {
                        key.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                key.close();
            }
            catch (Throwable throwable4) {
                try {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (key == null) throw throwable5;
                    if (throwable != null) {
                        try {
                            key.close();
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                            throw throwable5;
                        }
                    }
                    key.close();
                    throw throwable5;
                }
            }
        }
    }

    @Override
    public IV8ValueIterator<V8ValueArray> getEntries() throws JavetException {
        return (IV8ValueIterator)this.invoke(FUNCTION_ENTRIES, new V8Value[0]);
    }

    public IV8ValueIterator<V8Value> getKeys() throws JavetException {
        return (IV8ValueIterator)this.invoke(FUNCTION_KEYS, new V8Value[0]);
    }

    @Override
    public int getSize() throws JavetException {
        return this.checkV8Runtime().getV8Internal().setGetSize(this);
    }

    @Override
    public V8ValueReferenceType getType() {
        return V8ValueReferenceType.Set;
    }

    @Override
    public boolean has(Object value) throws JavetException {
        try (V8VirtualValue virtualValue = new V8VirtualValue(this.checkV8Runtime(), OBJECT_CONVERTER, Objects.requireNonNull(value));){
            boolean bl = this.v8Runtime.getV8Internal().setHas(this, (V8Value)virtualValue.get());
            return bl;
        }
    }
}

