/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.V8ValueInternalType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetBiConsumer;
import com.caoccao.javet.interfaces.IJavetBiIndexedConsumer;
import com.caoccao.javet.interfaces.IJavetUniConsumer;
import com.caoccao.javet.interfaces.IJavetUniIndexedConsumer;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueNull;
import com.caoccao.javet.values.primitive.V8ValuePrimitive;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.primitive.V8ValueUndefined;
import com.caoccao.javet.values.reference.IV8ValueArray;
import com.caoccao.javet.values.reference.IV8ValueReference;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public interface IV8ValueObject
extends IV8ValueReference {
    public static final int DEFAULT_BATCH_SIZE = 100;
    public static final int MIN_BATCH_SIZE = 1;

    public int batchGet(V8Value[] var1, V8Value[] var2, int var3) throws JavetException;

    public List<JavetCallbackContext> bind(Object var1) throws JavetException;

    public boolean bindFunction(JavetCallbackContext var1) throws JavetException;

    default public boolean bindFunction(String functionName, String codeString) throws JavetException {
        Objects.requireNonNull(functionName);
        Objects.requireNonNull(codeString);
        try (V8ValueFunction v8ValueFunction = this.getV8Runtime().createV8ValueFunction(codeString);){
            boolean bl = this.set((Object)functionName, (Object)v8ValueFunction);
            return bl;
        }
    }

    default public boolean bindFunction(V8ValueSymbol functionName, String codeString) throws JavetException {
        Objects.requireNonNull(functionName);
        Objects.requireNonNull(codeString);
        try (V8ValueFunction v8ValueFunction = this.getV8Runtime().createV8ValueFunction(codeString);){
            boolean bl = this.set((Object)functionName, (Object)v8ValueFunction);
            return bl;
        }
    }

    default public boolean bindProperty(JavetCallbackContext javetCallbackContextGetter) throws JavetException {
        return this.bindProperty(javetCallbackContextGetter, null);
    }

    public boolean bindProperty(JavetCallbackContext var1, JavetCallbackContext var2) throws JavetException;

    public boolean delete(Object var1) throws JavetException;

    default public boolean deleteNull() throws JavetException {
        return this.delete(this.getV8Runtime().createV8ValueNull());
    }

    public boolean deletePrivateProperty(String var1) throws JavetException;

    default public boolean deleteUndefined() throws JavetException {
        return this.delete(this.getV8Runtime().createV8ValueUndefined());
    }

    default public <Key extends V8Value, E extends Throwable> int forEach(IJavetUniConsumer<Key, E> consumer) throws JavetException, E {
        return this.forEach(consumer, 100);
    }

    default public <Key extends V8Value, E extends Throwable> int forEach(IJavetUniConsumer<Key, E> consumer, int batchSize) throws JavetException, E {
        Objects.requireNonNull(consumer);
        try (IV8ValueArray iV8ValueArray = this.getOwnPropertyNames();){
            int n = iV8ValueArray.forEach(consumer, batchSize);
            return n;
        }
    }

    default public <Key extends V8Value, E extends Throwable> int forEach(IJavetUniIndexedConsumer<Key, E> consumer) throws JavetException, E {
        return this.forEach(consumer, 100);
    }

    default public <Key extends V8Value, E extends Throwable> int forEach(IJavetUniIndexedConsumer<Key, E> consumer, int batchSize) throws JavetException, E {
        Objects.requireNonNull(consumer);
        try (IV8ValueArray iV8ValueArray = this.getOwnPropertyNames();){
            int n = iV8ValueArray.forEach(consumer, batchSize);
            return n;
        }
    }

    default public <Key extends V8Value, Value extends V8Value, E extends Throwable> int forEach(IJavetBiConsumer<Key, Value, E> consumer) throws JavetException, E {
        return this.forEach(consumer, 100);
    }

    public <Key extends V8Value, Value extends V8Value, E extends Throwable> int forEach(IJavetBiConsumer<Key, Value, E> var1, int var2) throws JavetException, E;

    default public <Key extends V8Value, Value extends V8Value, E extends Throwable> int forEach(IJavetBiIndexedConsumer<Key, Value, E> consumer) throws JavetException, E {
        return this.forEach(consumer, 100);
    }

    public <Key extends V8Value, Value extends V8Value, E extends Throwable> int forEach(IJavetBiIndexedConsumer<Key, Value, E> var1, int var2) throws JavetException, E;

    public <T extends V8Value> T get(Object var1) throws JavetException;

    default public BigInteger getBigInteger(Object key) throws JavetException {
        return (BigInteger)this.getPrimitive(key);
    }

    public Boolean getBoolean(Object var1) throws JavetException;

    public Double getDouble(Object var1) throws JavetException;

    default public Float getFloat(Object key) throws JavetException {
        Double result = this.getDouble(key);
        return result == null ? null : Float.valueOf(result.floatValue());
    }

    public int getIdentityHash() throws JavetException;

    public Integer getInteger(Object var1) throws JavetException;

    public Long getLong(Object var1) throws JavetException;

    default public V8ValueNull getNull(Object key) throws JavetException {
        return (V8ValueNull)this.get(key);
    }

    default public <T> T getObject(Object key) throws JavetException {
        try {
            return this.getV8Runtime().toObject(this.get(key), true);
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    default public List<String> getOwnPropertyNameStrings() throws JavetException {
        ArrayList<String> ownPropertyNameStrings = new ArrayList<String>();
        this.forEach((Key v8Value) -> {
            if (v8Value instanceof V8ValueString) {
                ownPropertyNameStrings.add((String)((V8ValueString)v8Value).getValue());
            }
        });
        return ownPropertyNameStrings;
    }

    public IV8ValueArray getOwnPropertyNames() throws JavetException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <R, T extends V8ValuePrimitive<R>> R getPrimitive(Object key) throws JavetException {
        try (T v8Value = this.get(key);){
            Object t = ((V8ValuePrimitive)v8Value).getValue();
            return (R)t;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable6) {
            return null;
        }
    }

    public <T extends V8Value> T getPrivateProperty(String var1) throws JavetException;

    default public Boolean getPrivatePropertyBoolean(String propertyName) throws JavetException {
        return (Boolean)this.getPrivatePropertyPrimitive(propertyName);
    }

    default public Double getPrivatePropertyDouble(String propertyName) throws JavetException {
        return (Double)this.getPrivatePropertyPrimitive(propertyName);
    }

    default public Float getPrivatePropertyFloat(String propertyName) throws JavetException {
        Double result = this.getPrivatePropertyDouble(propertyName);
        return result == null ? null : Float.valueOf(result.floatValue());
    }

    default public Integer getPrivatePropertyInteger(String propertyName) throws JavetException {
        return (Integer)this.getPrivatePropertyPrimitive(propertyName);
    }

    default public Long getPrivatePropertyLong(String propertyName) throws JavetException {
        return (Long)this.getPrivatePropertyPrimitive(propertyName);
    }

    default public V8ValueNull getPrivatePropertyNull(String propertyName) throws JavetException {
        return (V8ValueNull)this.getPrivateProperty(propertyName);
    }

    default public <T> T getPrivatePropertyObject(String propertyName) throws JavetException {
        try {
            return this.getV8Runtime().toObject(this.getPrivateProperty(propertyName), true);
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <R, T extends V8ValuePrimitive<R>> R getPrivatePropertyPrimitive(String propertyName) throws JavetException {
        try (T v8Value = this.getPrivateProperty(propertyName);){
            Object t = ((V8ValuePrimitive)v8Value).getValue();
            return (R)t;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable6) {
            return null;
        }
    }

    default public String getPrivatePropertyString(String propertyName) throws JavetException {
        return (String)this.getPrivatePropertyPrimitive(propertyName);
    }

    default public V8ValueUndefined getPrivatePropertyUndefined(String propertyName) throws JavetException {
        return (V8ValueUndefined)this.getPrivateProperty(propertyName);
    }

    default public ZonedDateTime getPrivatePropertyZonedDateTime(String propertyName) throws JavetException {
        return (ZonedDateTime)this.getPrivatePropertyPrimitive(propertyName);
    }

    public <T extends V8Value> T getProperty(Object var1) throws JavetException;

    default public Boolean getPropertyBoolean(Object key) throws JavetException {
        return (Boolean)this.getPropertyPrimitive(key);
    }

    default public Double getPropertyDouble(Object key) throws JavetException {
        return (Double)this.getPropertyPrimitive(key);
    }

    default public Float getPropertyFloat(Object key) throws JavetException {
        Double result = this.getPropertyDouble(key);
        return result == null ? null : Float.valueOf(result.floatValue());
    }

    default public Integer getPropertyInteger(Object key) throws JavetException {
        return (Integer)this.getPropertyPrimitive(key);
    }

    default public Long getPropertyLong(Object key) throws JavetException {
        return (Long)this.getPropertyPrimitive(key);
    }

    public IV8ValueArray getPropertyNames() throws JavetException;

    default public <T> T getPropertyObject(Object key) throws JavetException {
        try {
            return this.getV8Runtime().toObject(this.getProperty(key), true);
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <R, T extends V8ValuePrimitive<R>> R getPropertyPrimitive(Object key) throws JavetException {
        try (T v8Value = this.getProperty(key);){
            Object t = ((V8ValuePrimitive)v8Value).getValue();
            return (R)t;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable6) {
            return null;
        }
    }

    default public String getPropertyString(Object key) throws JavetException {
        return (String)this.getPropertyPrimitive(key);
    }

    default public ZonedDateTime getPropertyZonedDateTime(Object key) throws JavetException {
        return (ZonedDateTime)this.getPropertyPrimitive(key);
    }

    public <T extends IV8ValueObject> T getPrototype() throws JavetException;

    public String getString(Object var1) throws JavetException;

    default public V8ValueUndefined getUndefined(Object key) throws JavetException {
        return (V8ValueUndefined)this.get(key);
    }

    default public ZonedDateTime getZonedDateTime(Object key) throws JavetException {
        return (ZonedDateTime)this.getPrimitive(key);
    }

    public boolean has(Object var1) throws JavetException;

    public boolean hasInternalType(V8ValueInternalType var1) throws JavetException;

    default public boolean hasNull() throws JavetException {
        return this.has(this.getV8Runtime().createV8ValueNull());
    }

    public boolean hasOwnProperty(Object var1) throws JavetException;

    public boolean hasPrivateProperty(String var1) throws JavetException;

    default public boolean hasUndefined() throws JavetException {
        return this.has(this.getV8Runtime().createV8ValueUndefined());
    }

    default public <T extends V8Value> T invoke(String functionName, Object ... objects) throws JavetException {
        return this.invokeExtended(functionName, true, objects);
    }

    default public <T extends V8Value> T invoke(String functionName, V8Value ... v8Values) throws JavetException {
        return this.invokeExtended(functionName, true, v8Values);
    }

    default public Boolean invokeBoolean(String functionName, Object ... objects) throws JavetException {
        return (Boolean)this.invokePrimitive(functionName, objects);
    }

    default public Double invokeDouble(String functionName, Object ... objects) throws JavetException {
        return (Double)this.invokePrimitive(functionName, objects);
    }

    public <T extends V8Value> T invokeExtended(String var1, boolean var2, Object ... var3) throws JavetException;

    public <T extends V8Value> T invokeExtended(String var1, boolean var2, V8Value ... var3) throws JavetException;

    default public Float invokeFloat(String functionName, Object ... objects) throws JavetException {
        Double result = this.invokeDouble(functionName, objects);
        return result == null ? null : Float.valueOf(result.floatValue());
    }

    default public Integer invokeInteger(String functionName, Object ... objects) throws JavetException {
        return (Integer)this.invokePrimitive(functionName, objects);
    }

    default public Long invokeLong(String functionName, Object ... objects) throws JavetException {
        return (Long)this.invokePrimitive(functionName, objects);
    }

    default public <T> T invokeObject(String functionName, Object ... objects) throws JavetException {
        try {
            return this.getV8Runtime().toObject(this.invokeExtended(functionName, true, objects), true);
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <R, T extends V8ValuePrimitive<R>> R invokePrimitive(String functionName, Object ... objects) throws JavetException {
        try (T v8Value = this.invokeExtended(functionName, true, objects);){
            Object t = ((V8ValuePrimitive)v8Value).getValue();
            return (R)t;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t2) {
            return null;
        }
    }

    default public String invokeString(String functionName, Object ... objects) throws JavetException {
        return (String)this.invokePrimitive(functionName, objects);
    }

    default public void invokeVoid(String functionName, Object ... objects) throws JavetException {
        this.invokeExtended(functionName, false, objects);
    }

    default public void invokeVoid(String functionName, V8Value ... v8Values) throws JavetException {
        this.invokeExtended(functionName, false, v8Values);
    }

    default public boolean isGeneratorObject() throws JavetException {
        return this.hasInternalType(V8ValueInternalType.GeneratorObject);
    }

    public boolean set(Object var1, Object var2) throws JavetException;

    public boolean set(Object ... var1) throws JavetException;

    public boolean setBoolean(Object var1, Boolean var2) throws JavetException;

    public boolean setDouble(Object var1, Double var2) throws JavetException;

    public boolean setInteger(Object var1, Integer var2) throws JavetException;

    public boolean setLong(Object var1, Long var2) throws JavetException;

    public boolean setNull(Object var1) throws JavetException;

    public boolean setPrivateProperty(String var1, Object var2) throws JavetException;

    default public boolean setPrivatePropertyNull(String propertyName) throws JavetException {
        return this.setPrivateProperty(propertyName, this.getV8Runtime().createV8ValueNull());
    }

    default public boolean setPrivatePropertyUndefined(String propertyName) throws JavetException {
        return this.setPrivateProperty(propertyName, this.getV8Runtime().createV8ValueUndefined());
    }

    public boolean setProperty(Object var1, Object var2) throws JavetException;

    default public boolean setPropertyNull(Object key) throws JavetException {
        return this.setProperty(key, this.getV8Runtime().createV8ValueNull());
    }

    default public boolean setPropertyUndefined(Object key) throws JavetException {
        return this.setProperty(key, this.getV8Runtime().createV8ValueUndefined());
    }

    public boolean setPrototype(IV8ValueObject var1) throws JavetException;

    public boolean setString(Object var1, String var2) throws JavetException;

    public boolean setUndefined(Object var1) throws JavetException;

    public String toJsonString();

    public String toProtoString();

    public int unbind(Object var1) throws JavetException;

    default public boolean unbindFunction(String functionName) throws JavetException {
        return this.delete(functionName);
    }

    default public boolean unbindFunction(V8ValueString functionName) throws JavetException {
        return this.delete(functionName);
    }

    default public boolean unbindFunction(V8ValueSymbol functionName) throws JavetException {
        return this.delete(functionName);
    }

    public boolean unbindProperty(JavetCallbackContext var1) throws JavetException;

    default public boolean unbindProperty(String propertyName) throws JavetException {
        return this.unbindProperty(this.getV8Runtime().createV8ValueString(Objects.requireNonNull(propertyName)));
    }

    public boolean unbindProperty(V8ValueString var1) throws JavetException;

    public boolean unbindProperty(V8ValueSymbol var1) throws JavetException;
}

