/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.primitive;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.primitive.V8ValuePrimitive;
import java.math.BigDecimal;

public class V8ValueDouble
extends V8ValuePrimitive<Double> {
    protected String cachedToString = null;

    public V8ValueDouble(V8Runtime v8Runtime) throws JavetException {
        this(v8Runtime, 0.0);
    }

    public V8ValueDouble(V8Runtime v8Runtime, double value) throws JavetException {
        super(v8Runtime, value);
    }

    public boolean isFinite() {
        return Double.isFinite((Double)this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite((Double)this.value);
    }

    public boolean isNaN() {
        return Double.isNaN((Double)this.value);
    }

    public V8ValueDouble toClone(boolean referenceCopy) throws JavetException {
        return this;
    }

    public double toPrimitive() {
        return (Double)this.value;
    }

    @Override
    public String toString() {
        if (this.cachedToString == null) {
            this.cachedToString = new BigDecimal(((Double)this.value).toString()).toPlainString();
        }
        return this.cachedToString;
    }
}

