/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.JSFunctionType;
import com.caoccao.javet.enums.JSScopeType;
import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Internal;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.utils.StringUtils;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueArray;
import com.caoccao.javet.values.reference.IV8ValueFunction;
import com.caoccao.javet.values.reference.V8Context;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.virtual.V8VirtualValueList;
import java.util.Objects;

public class V8ValueFunction
extends V8ValueObject
implements IV8ValueFunction {
    protected static final String ERROR_THE_SOURCE_FUNCTION_CANNOT_BE_IN_ANOTHER_V8_RUNTIME = "The source function cannot be in another V8 runtime.";
    protected static final String ERROR_THE_SOURCE_FUNCTION_CANNOT_BE_THE_CALLER = "The source function cannot be the caller.";
    protected static final String ERROR_V8_CONTEXT_CANNOT_BE_NULL = "V8 context cannot be null.";
    protected JSFunctionType jsFunctionType = null;

    protected V8ValueFunction(V8Runtime v8Runtime, long handle) throws JavetException {
        super(v8Runtime, handle);
    }

    @Override
    public <T extends V8Value> T callAsConstructor(Object ... objects) throws JavetException {
        try (V8VirtualValueList virtualValueList = new V8VirtualValueList(this.checkV8Runtime(), null, objects);){
            Object t = this.v8Runtime.getV8Internal().functionCallAsConstructor(this, virtualValueList.get());
            return t;
        }
    }

    @Override
    public <T extends V8Value> T callAsConstructor(V8Value ... v8Values) throws JavetException {
        return this.checkV8Runtime().getV8Internal().functionCallAsConstructor(this, v8Values);
    }

    @Override
    public <T extends V8Value> T callExtended(V8Value receiver, boolean returnResult, Object ... objects) throws JavetException {
        try (V8VirtualValueList virtualValueList = new V8VirtualValueList(this.checkV8Runtime(), null, objects);){
            Object t = this.v8Runtime.getV8Internal().functionCall(this, receiver, returnResult, virtualValueList.get());
            return t;
        }
    }

    @Override
    public <T extends V8Value> T callExtended(V8Value receiver, boolean returnResult, V8Value ... v8Values) throws JavetException {
        return this.checkV8Runtime().getV8Internal().functionCall(this, receiver, returnResult, v8Values);
    }

    @Override
    public boolean canDiscardCompiled() throws JavetException {
        return this.checkV8Runtime().getV8Internal().functionCanDiscardCompiled(this);
    }

    @Override
    public boolean copyScopeInfoFrom(IV8ValueFunction sourceIV8ValueFunction) throws JavetException {
        assert (this != Objects.requireNonNull(sourceIV8ValueFunction)) : "The source function cannot be the caller.";
        assert (this.checkV8Runtime() == sourceIV8ValueFunction.getV8Runtime()) : "The source function cannot be in another V8 runtime.";
        if (!this.getJSFunctionType().isUserDefined() || !sourceIV8ValueFunction.getJSFunctionType().isUserDefined()) {
            return false;
        }
        return this.v8Runtime.getV8Internal().functionCopyScopeInfoFrom(this, sourceIV8ValueFunction);
    }

    @Override
    public boolean discardCompiled() throws JavetException {
        return this.checkV8Runtime().getV8Internal().functionDiscardCompiled(this);
    }

    @Override
    public String[] getArguments() throws JavetException {
        return this.checkV8Runtime().getV8Internal().functionGetArguments(this);
    }

    @Override
    public byte[] getCachedData() throws JavetException {
        return this.checkV8Runtime().getV8Internal().functionGetCachedData(this);
    }

    @Override
    public V8Context getContext() throws JavetException {
        return this.checkV8Runtime().getV8Internal().functionGetContext(this);
    }

    @Override
    public IV8ValueArray getInternalProperties() throws JavetException {
        return this.checkV8Runtime().getV8Internal().functionGetInternalProperties(this);
    }

    @Override
    public JSFunctionType getJSFunctionType() throws JavetException {
        if (this.jsFunctionType == null) {
            this.jsFunctionType = this.checkV8Runtime().getV8Internal().functionGetJSFunctionType(this);
        }
        return this.jsFunctionType;
    }

    @Override
    public JSScopeType getJSScopeType() throws JavetException {
        return this.checkV8Runtime().getV8Internal().functionGetJSScopeType(this);
    }

    @Override
    public IV8ValueFunction.ScopeInfos getScopeInfos(IV8ValueFunction.GetScopeInfosOptions options) throws JavetException {
        try (IV8ValueArray iV8ValueArray = this.checkV8Runtime().getV8Internal().functionGetScopeInfos(this, options);){
            IV8ValueFunction.ScopeInfos scopeInfos = new IV8ValueFunction.ScopeInfos(iV8ValueArray);
            return scopeInfos;
        }
    }

    @Override
    public IV8ValueFunction.ScriptSource getScriptSource() throws JavetException {
        if (this.getJSFunctionType().isUserDefined()) {
            return this.checkV8Runtime().getV8Internal().functionGetScriptSource(this);
        }
        return null;
    }

    @Override
    public String getSourceCode() throws JavetException {
        if (this.getJSFunctionType().isUserDefined()) {
            return this.checkV8Runtime().getV8Internal().functionGetSourceCode(this);
        }
        return null;
    }

    @Override
    public V8ValueReferenceType getType() {
        return V8ValueReferenceType.Function;
    }

    @Override
    public boolean isCompiled() throws JavetException {
        return this.checkV8Runtime().getV8Internal().functionIsCompiled(this);
    }

    @Override
    public boolean isWrapped() throws JavetException {
        return this.checkV8Runtime().getV8Internal().functionIsWrapped(this);
    }

    @Override
    public boolean setContext(V8Context v8Context) throws JavetException {
        Objects.requireNonNull(v8Context, ERROR_V8_CONTEXT_CANNOT_BE_NULL);
        return this.checkV8Runtime().getV8Internal().functionSetContext(this, v8Context);
    }

    @Override
    public boolean setScriptSource(IV8ValueFunction.ScriptSource scriptSource, boolean cloneScript) throws JavetException {
        boolean success = false;
        if (this.getJSFunctionType().isUserDefined() && (this.getJSScopeType().isFunction() || this.getJSScopeType().isScript()) && scriptSource != null) {
            success = this.checkV8Runtime().getV8Internal().functionSetScriptSource(this, scriptSource, cloneScript);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setSourceCode(String sourceCodeString, IV8ValueFunction.SetSourceCodeOptions options) throws JavetException {
        Objects.requireNonNull(options, "Options cannot be null.");
        boolean success = false;
        if (this.getJSFunctionType().isUserDefined() && (this.getJSScopeType().isFunction() || this.getJSScopeType().isScript()) && StringUtils.isNotEmpty(sourceCodeString)) {
            if (options.isTrimTailingCharacters()) {
                sourceCodeString = V8ValueUtils.trimAnonymousFunction(sourceCodeString);
            }
            V8Internal v8Internal = this.checkV8Runtime().getV8Internal();
            if (options.isPreGC()) {
                this.v8Runtime.lowMemoryNotification();
            }
            try {
                if (options.isNativeCalculation()) {
                    success = v8Internal.functionSetSourceCode(this, sourceCodeString, options.isCloneScript());
                } else {
                    IV8ValueFunction.ScriptSource originalScriptSource = v8Internal.functionGetScriptSource(this);
                    IV8ValueFunction.ScriptSource newScriptSource = originalScriptSource.setCodeSnippet(sourceCodeString);
                    if (this.getJSFunctionType().isUserDefined() && (this.getJSScopeType().isFunction() || this.getJSScopeType().isScript())) {
                        success = v8Internal.functionSetScriptSource(this, newScriptSource, options.isCloneScript());
                    }
                }
            }
            finally {
                if (options.isPostGC()) {
                    this.v8Runtime.lowMemoryNotification();
                }
            }
        }
        return success;
    }
}

