/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.options;

import com.caoccao.javet.utils.ArrayUtils;
import com.caoccao.javet.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Stream;

public final class NodeFlags {
    public static final String ALLOW_FS_READ = "--allow-fs-read";
    public static final String ALLOW_FS_WRITE = "--allow-fs-write";
    public static final String EXPERIMENTAL_PERMISSION = "--experimental-permission";
    public static final String EXPERIMENTAL_REQUIRE_MODULE = "--experimental-require-module";
    public static final String EXPERIMENTAL_SQLITE = "--experimental-sqlite";
    public static final String ICU_DATA_DIR = "--icu-data-dir";
    public static final String NO_WARNINGS = "--no-warnings";
    private static final String EQUAL = "=";
    private static final String SPACE = " ";
    private String[] allowFsRead = null;
    private String[] allowFsWrite = null;
    private String[] customFlags = null;
    private boolean experimentalPermission = false;
    private boolean experimentalRequireModule = false;
    private boolean experimentalSqlite = false;
    private String icuDataDir;
    private boolean noWarnings = false;
    private boolean sealed = false;

    NodeFlags() {
    }

    public String[] getAllowFsRead() {
        return this.allowFsRead;
    }

    public String[] getAllowFsWrite() {
        return this.allowFsWrite;
    }

    public String[] getCustomFlags() {
        return this.customFlags;
    }

    public String getIcuDataDir() {
        return this.icuDataDir;
    }

    public boolean isExperimentalPermission() {
        return this.experimentalPermission;
    }

    public boolean isExperimentalRequireModule() {
        return this.experimentalRequireModule;
    }

    public boolean isExperimentalSqlite() {
        return this.experimentalSqlite;
    }

    public boolean isNoWarnings() {
        return this.noWarnings;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public NodeFlags seal() {
        if (!this.sealed) {
            this.sealed = true;
        }
        return this;
    }

    public NodeFlags setAllowFsRead(String[] allowFsRead) {
        if (!this.sealed) {
            if (ArrayUtils.isEmpty(allowFsRead)) {
                this.allowFsRead = null;
            } else {
                this.allowFsRead = (String[])Stream.of(allowFsRead).filter(StringUtils::isNotBlank).toArray(String[]::new);
                this.experimentalPermission = true;
            }
        }
        return this;
    }

    public NodeFlags setAllowFsWrite(String[] allowFsWrite) {
        if (!this.sealed) {
            if (ArrayUtils.isEmpty(allowFsWrite)) {
                this.allowFsWrite = null;
            } else {
                this.allowFsWrite = (String[])Stream.of(allowFsWrite).filter(StringUtils::isNotBlank).toArray(String[]::new);
                this.experimentalPermission = true;
            }
        }
        return this;
    }

    public NodeFlags setCustomFlags(String[] customFlags) {
        if (!this.sealed) {
            this.customFlags = ArrayUtils.isEmpty(customFlags) ? null : (String[])Stream.of(customFlags).filter(StringUtils::isNotBlank).toArray(String[]::new);
        }
        return this;
    }

    public NodeFlags setExperimentalPermission(boolean experimentalPermission) {
        if (!this.sealed) {
            this.experimentalPermission = experimentalPermission;
        }
        return this;
    }

    public NodeFlags setExperimentalRequireModule(boolean experimentalRequireModule) {
        if (!this.sealed) {
            this.experimentalRequireModule = experimentalRequireModule;
        }
        return this;
    }

    public NodeFlags setExperimentalSqlite(boolean experimentalSqlite) {
        if (!this.sealed) {
            this.experimentalSqlite = experimentalSqlite;
        }
        return this;
    }

    public NodeFlags setIcuDataDir(String icuDataDir) {
        if (!this.sealed) {
            this.icuDataDir = icuDataDir;
        }
        return this;
    }

    public NodeFlags setNoWarnings(boolean noWarnings) {
        if (!this.sealed) {
            this.noWarnings = noWarnings;
        }
        return this;
    }

    public String[] toArray() {
        ArrayList<String> tokens = new ArrayList<String>();
        if (ArrayUtils.isNotEmpty(this.allowFsRead)) {
            Stream.of(this.allowFsRead).filter(StringUtils::isNotBlank).map(path -> "--allow-fs-read=" + path.trim()).forEach(tokens::add);
        }
        if (ArrayUtils.isNotEmpty(this.allowFsWrite)) {
            Stream.of(this.allowFsWrite).filter(StringUtils::isNotBlank).map(path -> "--allow-fs-write=" + path.trim()).forEach(tokens::add);
        }
        if (this.experimentalPermission) {
            tokens.add(EXPERIMENTAL_PERMISSION);
        }
        if (this.experimentalRequireModule) {
            tokens.add(EXPERIMENTAL_REQUIRE_MODULE);
        }
        if (this.experimentalSqlite) {
            tokens.add(EXPERIMENTAL_SQLITE);
        }
        if (StringUtils.isNotBlank(this.icuDataDir)) {
            tokens.add("--icu-data-dir=" + this.icuDataDir.trim());
        }
        if (this.noWarnings) {
            tokens.add(NO_WARNINGS);
        }
        tokens.sort(String::compareTo);
        if (ArrayUtils.isNotEmpty(this.customFlags)) {
            Collections.addAll(tokens, this.customFlags);
        }
        return tokens.toArray(new String[0]);
    }

    public String toString() {
        return StringUtils.join((CharSequence)SPACE, this.toArray());
    }
}

