/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.engine.observers;

import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.engine.observers.IV8RuntimeObserver;
import com.caoccao.javet.interop.monitoring.V8HeapStatistics;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class V8RuntimeObserverAverageV8HeapStatistics
implements IV8RuntimeObserver<V8HeapStatistics> {
    protected static final int DEFAULT_CAPACITY = 256;
    protected static final int DEFAULT_TIMEOUT_MILLIS = 5000;
    protected final int timeoutMillis;
    protected final List<CompletableFuture<V8HeapStatistics>> v8HeapStatisticsFutureList;

    public V8RuntimeObserverAverageV8HeapStatistics() {
        this(256, 5000);
    }

    public V8RuntimeObserverAverageV8HeapStatistics(int capacity, int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        this.v8HeapStatisticsFutureList = new ArrayList<CompletableFuture<V8HeapStatistics>>(capacity);
    }

    @Override
    public V8HeapStatistics getResult() {
        long doesZapGarbage = 0L;
        long externalMemory = 0L;
        long heapSizeLimit = 0L;
        long mallocedMemory = 0L;
        long numberOfDetachedContexts = 0L;
        long numberOfNativeContexts = 0L;
        long peakMallocedMemory = 0L;
        long totalAvailableSize = 0L;
        long totalGlobalHandlesSize = 0L;
        long totalHeapSize = 0L;
        long totalHeapSizeExecutable = 0L;
        long totalPhysicalSize = 0L;
        long usedGlobalHandlesSize = 0L;
        long usedHeapSize = 0L;
        if (!this.v8HeapStatisticsFutureList.isEmpty()) {
            int count = 0;
            long expectedEndTime = System.currentTimeMillis() + (long)this.timeoutMillis;
            for (CompletableFuture<V8HeapStatistics> v8HeapStatisticsFuture : this.v8HeapStatisticsFutureList) {
                try {
                    long now = System.currentTimeMillis();
                    V8HeapStatistics v8HeapStatistics = now < expectedEndTime ? v8HeapStatisticsFuture.get(expectedEndTime - now, TimeUnit.MILLISECONDS) : (V8HeapStatistics)v8HeapStatisticsFuture.getNow(null);
                    if (v8HeapStatistics == null) continue;
                    doesZapGarbage += v8HeapStatistics.getDoesZapGarbage();
                    externalMemory += v8HeapStatistics.getExternalMemory();
                    heapSizeLimit += v8HeapStatistics.getHeapSizeLimit();
                    mallocedMemory += v8HeapStatistics.getMallocedMemory();
                    numberOfDetachedContexts += v8HeapStatistics.getNumberOfDetachedContexts();
                    numberOfNativeContexts += v8HeapStatistics.getNumberOfNativeContexts();
                    peakMallocedMemory += v8HeapStatistics.getPeakMallocedMemory();
                    totalAvailableSize += v8HeapStatistics.getTotalAvailableSize();
                    totalGlobalHandlesSize += v8HeapStatistics.getTotalGlobalHandlesSize();
                    totalHeapSize += v8HeapStatistics.getTotalHeapSize();
                    totalHeapSizeExecutable += v8HeapStatistics.getTotalHeapSizeExecutable();
                    totalPhysicalSize += v8HeapStatistics.getTotalPhysicalSize();
                    usedGlobalHandlesSize += v8HeapStatistics.getUsedGlobalHandlesSize();
                    usedHeapSize += v8HeapStatistics.getUsedHeapSize();
                    ++count;
                }
                catch (Throwable throwable) {}
            }
            if (count > 0) {
                doesZapGarbage /= (long)count;
                externalMemory /= (long)count;
                heapSizeLimit /= (long)count;
                mallocedMemory /= (long)count;
                numberOfDetachedContexts /= (long)count;
                numberOfNativeContexts /= (long)count;
                peakMallocedMemory /= (long)count;
                totalAvailableSize /= (long)count;
                totalGlobalHandlesSize /= (long)count;
                totalHeapSize /= (long)count;
                totalHeapSizeExecutable /= (long)count;
                totalPhysicalSize /= (long)count;
                usedGlobalHandlesSize /= (long)count;
                usedHeapSize /= (long)count;
            }
        }
        return new V8HeapStatistics(doesZapGarbage, externalMemory, heapSizeLimit, mallocedMemory, numberOfDetachedContexts, numberOfNativeContexts, peakMallocedMemory, totalAvailableSize, totalGlobalHandlesSize, totalHeapSize, totalHeapSizeExecutable, totalPhysicalSize, usedGlobalHandlesSize, usedHeapSize);
    }

    @Override
    public void observe(V8Runtime v8Runtime) {
        this.v8HeapStatisticsFutureList.add(v8Runtime.getV8HeapStatistics());
    }

    @Override
    public void reset() {
        this.v8HeapStatisticsFutureList.clear();
    }
}

