/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValuePrimitive;
import com.caoccao.javet.values.reference.IV8ValueFunction;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValuePromise;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.Objects;

public interface IV8ValuePromise
extends IV8ValueObject {
    public static final int STATE_PENDING = 0;
    public static final int STATE_FULFILLED = 1;
    public static final int STATE_REJECTED = 2;

    public V8ValuePromise _catch(IV8ValueFunction var1) throws JavetException;

    default public V8ValuePromise _catch(String codeString) throws JavetException {
        Objects.requireNonNull(codeString);
        try (V8ValueFunction v8ValueFunction = (V8ValueFunction)this.getV8Runtime().getExecutor(codeString).execute();){
            V8ValuePromise v8ValuePromise = this._catch(v8ValueFunction);
            return v8ValuePromise;
        }
    }

    public V8ValuePromise getPromise() throws JavetException;

    public <Value extends V8Value> Value getResult() throws JavetException;

    default public BigInteger getResultBigInteger() throws JavetException {
        return (BigInteger)this.getResultPrimitive();
    }

    default public boolean getResultBoolean() throws JavetException {
        return (Boolean)this.getResultPrimitive();
    }

    default public double getResultDouble() throws JavetException {
        return (Double)this.getResultPrimitive();
    }

    default public int getResultInteger() throws JavetException {
        return (Integer)this.getResultPrimitive();
    }

    default public long getResultLong() throws JavetException {
        return (Long)this.getResultPrimitive();
    }

    default public <T> T getResultObject() throws JavetException {
        try {
            return this.getV8Runtime().toObject(this.getResult(), true);
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    default public <R, T extends V8ValuePrimitive<R>> R getResultPrimitive() throws JavetException {
        Object v8Value = this.getResult();
        try {
            return (R)((V8ValuePrimitive)v8Value).getValue();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    default public String getResultString() throws JavetException {
        return (String)this.getResultPrimitive();
    }

    default public ZonedDateTime getResultZonedDateTime() throws JavetException {
        return (ZonedDateTime)this.getResultPrimitive();
    }

    public int getState() throws JavetException;

    public boolean hasHandler() throws JavetException;

    default public boolean isFulfilled() throws JavetException {
        return 1 == this.getState();
    }

    default public boolean isPending() throws JavetException {
        return 0 == this.getState();
    }

    default public boolean isRejected() throws JavetException {
        return 2 == this.getState();
    }

    public void markAsHandled() throws JavetException;

    public boolean register(IListener var1) throws JavetException;

    public boolean reject(V8Value var1) throws JavetException;

    default public boolean reject(Object object) throws JavetException {
        try (Object v8Value = this.getV8Runtime().toV8Value(object);){
            boolean bl = this.reject((V8Value)v8Value);
            return bl;
        }
    }

    public boolean resolve(V8Value var1) throws JavetException;

    default public boolean resolve(Object object) throws JavetException {
        try (Object v8Value = this.getV8Runtime().toV8Value(object);){
            boolean bl = this.resolve((V8Value)v8Value);
            return bl;
        }
    }

    default public V8ValuePromise then(IV8ValueFunction functionFulfilled) throws JavetException {
        return this.then(functionFulfilled, null);
    }

    public V8ValuePromise then(IV8ValueFunction var1, IV8ValueFunction var2) throws JavetException;

    default public V8ValuePromise then(String codeStringFulfilled) throws JavetException {
        return this.then(codeStringFulfilled, null);
    }

    /*
     * Exception decompiling
     */
    default public V8ValuePromise then(String codeStringFulfilled, String codeStringRejected) throws JavetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static interface IListener {
        public static final String ON_CATCH = "onCatch";
        public static final String ON_FULFILLED = "onFulfilled";
        public static final String ON_REJECTED = "onRejected";

        public void onCatch(V8Value var1);

        public void onFulfilled(V8Value var1);

        public void onRejected(V8Value var1);
    }
}

