/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.engine;

import com.caoccao.javet.enums.V8AllocationSpace;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetClosable;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.engine.IJavetEngine;
import com.caoccao.javet.interop.engine.JavetEngineConfig;
import com.caoccao.javet.interop.engine.observers.IV8RuntimeObserver;
import com.caoccao.javet.interop.engine.observers.V8RuntimeObserverAverageCallbackContextCount;
import com.caoccao.javet.interop.engine.observers.V8RuntimeObserverAverageReferenceCount;
import com.caoccao.javet.interop.engine.observers.V8RuntimeObserverAverageV8HeapSpaceStatistics;
import com.caoccao.javet.interop.engine.observers.V8RuntimeObserverAverageV8HeapStatistics;
import com.caoccao.javet.interop.engine.observers.V8RuntimeObserverAverageV8ModuleCount;
import com.caoccao.javet.interop.monitoring.V8HeapSpaceStatistics;
import com.caoccao.javet.interop.monitoring.V8HeapStatistics;
import com.caoccao.javet.interop.monitoring.V8SharedMemoryStatistics;

public interface IJavetEnginePool<R extends V8Runtime>
extends IJavetClosable {
    public int getActiveEngineCount();

    default public int getAverageCallbackContextCount() {
        V8RuntimeObserverAverageCallbackContextCount observer = new V8RuntimeObserverAverageCallbackContextCount(this.getConfig().getPoolMaxSize());
        this.observe(observer);
        return observer.getResult();
    }

    default public int getAverageReferenceCount() {
        V8RuntimeObserverAverageReferenceCount observer = new V8RuntimeObserverAverageReferenceCount(this.getConfig().getPoolMaxSize());
        this.observe(observer);
        return observer.getResult();
    }

    default public V8HeapSpaceStatistics getAverageV8HeapSpaceStatistics(V8AllocationSpace v8AllocationSpace) {
        V8RuntimeObserverAverageV8HeapSpaceStatistics observer = new V8RuntimeObserverAverageV8HeapSpaceStatistics(v8AllocationSpace, this.getConfig().getPoolMaxSize(), this.getConfig().getObserverTimeoutMillis());
        this.observe(observer);
        return observer.getResult();
    }

    default public V8HeapStatistics getAverageV8HeapStatistics() {
        V8RuntimeObserverAverageV8HeapStatistics observer = new V8RuntimeObserverAverageV8HeapStatistics(this.getConfig().getPoolMaxSize(), this.getConfig().getObserverTimeoutMillis());
        this.observe(observer);
        return observer.getResult();
    }

    default public int getAverageV8ModuleCount() {
        V8RuntimeObserverAverageV8ModuleCount observer = new V8RuntimeObserverAverageV8ModuleCount(this.getConfig().getPoolMaxSize());
        this.observe(observer);
        return observer.getResult();
    }

    public JavetEngineConfig getConfig();

    public IJavetEngine<R> getEngine() throws JavetException;

    public int getIdleEngineCount();

    public int getReleasedEngineCount();

    public V8SharedMemoryStatistics getV8SharedMemoryStatistics();

    public boolean isActive();

    public boolean isQuitting();

    public int observe(IV8RuntimeObserver<?> ... var1);

    public void releaseEngine(IJavetEngine<R> var1);

    public void wakeUpDaemon();
}

