/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interception.logging;

import com.caoccao.javet.interception.logging.BaseJavetConsoleInterceptor;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.V8Value;
import java.io.PrintStream;

public class JavetStandardConsoleInterceptor
extends BaseJavetConsoleInterceptor {
    protected PrintStream debug;
    protected PrintStream error;
    protected PrintStream info;
    protected PrintStream log;
    protected PrintStream trace;
    protected PrintStream warn;

    public JavetStandardConsoleInterceptor(V8Runtime v8Runtime) {
        super(v8Runtime);
        this.trace = this.warn = System.out;
        this.log = this.warn;
        this.info = this.warn;
        this.debug = this.warn;
        this.error = System.err;
    }

    @Override
    public void consoleDebug(V8Value ... v8Values) {
        this.debug.println(this.concat(v8Values));
    }

    @Override
    public void consoleError(V8Value ... v8Values) {
        this.error.println(this.concat(v8Values));
    }

    @Override
    public void consoleInfo(V8Value ... v8Values) {
        this.info.println(this.concat(v8Values));
    }

    @Override
    public void consoleLog(V8Value ... v8Values) {
        this.log.println(this.concat(v8Values));
    }

    @Override
    public void consoleTrace(V8Value ... v8Values) {
        this.trace.println(this.concat(v8Values));
    }

    @Override
    public void consoleWarn(V8Value ... v8Values) {
        this.warn.println(this.concat(v8Values));
    }

    public PrintStream getDebug() {
        return this.debug;
    }

    public PrintStream getError() {
        return this.error;
    }

    public PrintStream getInfo() {
        return this.info;
    }

    public PrintStream getLog() {
        return this.log;
    }

    public PrintStream getTrace() {
        return this.trace;
    }

    public PrintStream getWarn() {
        return this.warn;
    }

    public void setDebug(PrintStream debug) {
        this.debug = debug;
    }

    public void setError(PrintStream error) {
        this.error = error;
    }

    public void setInfo(PrintStream info) {
        this.info = info;
    }

    public void setLog(PrintStream log) {
        this.log = log;
    }

    public void setTrace(PrintStream trace) {
        this.trace = trace;
    }

    public void setWarn(PrintStream warn) {
        this.warn = warn;
    }
}

