/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.enums;

import java.util.stream.Stream;

public enum V8ContextType {
    Await(0, "Await"),
    Block(1, "Block"),
    Catch(2, "Catch"),
    DebugEvaluate(3, "DebugEvaluate"),
    Declaration(4, "Declaration"),
    Eval(5, "Eval"),
    Function(6, "Function"),
    Module(7, "Module"),
    Script(8, "Script"),
    With(9, "With");

    private static final int LENGTH;
    private static final V8ContextType[] TYPES;
    private final int id;
    private final String name;

    private V8ContextType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static V8ContextType parse(int id) {
        return id >= 0 && id < LENGTH ? TYPES[id] : Await;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    static {
        LENGTH = V8ContextType.values().length;
        TYPES = new V8ContextType[LENGTH];
        Stream.of(V8ContextType.values()).forEach(v -> {
            V8ContextType.TYPES[v.getId()] = v;
        });
    }
}

