/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.enums;

import java.util.stream.Stream;

public enum V8ScopeType {
    Global(0, "Global"),
    Local(1, "Local"),
    With(2, "With"),
    Closure(3, "Closure"),
    Catch(4, "Catch"),
    Block(5, "Block"),
    Script(6, "Script"),
    Eval(7, "Eval"),
    Module(8, "Module");

    private static final int LENGTH;
    private static final V8ScopeType[] TYPES;
    private final int id;
    private final String name;

    private V8ScopeType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static V8ScopeType parse(int id) {
        return id >= 0 && id < LENGTH ? TYPES[id] : Global;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    static {
        LENGTH = V8ScopeType.values().length;
        TYPES = new V8ScopeType[LENGTH];
        Stream.of(V8ScopeType.values()).forEach(v -> {
            V8ScopeType.TYPES[v.getId()] = v;
        });
    }
}

