/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.engine;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Guard;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.engine.IJavetEngine;
import com.caoccao.javet.interop.engine.IJavetEnginePool;
import com.caoccao.javet.interop.engine.JavetEngineConfig;
import com.caoccao.javet.interop.engine.JavetEngineUsage;
import com.caoccao.javet.utils.JavetDateTimeUtils;
import java.time.ZonedDateTime;
import java.util.Objects;

public class JavetEngine<R extends V8Runtime>
implements IJavetEngine<R> {
    protected volatile boolean active;
    protected IJavetEnginePool<R> iJavetEnginePool;
    protected int index;
    protected JavetEngineUsage usage;
    protected R v8Runtime;

    public JavetEngine(IJavetEnginePool<R> iJavetEnginePool, R v8Runtime) {
        this.iJavetEnginePool = Objects.requireNonNull(iJavetEnginePool);
        this.v8Runtime = (V8Runtime)Objects.requireNonNull(v8Runtime);
        this.usage = new JavetEngineUsage();
        this.setActive(false);
    }

    @Override
    public void close() throws JavetException {
        this.close(false);
    }

    protected void close(boolean forceClose) throws JavetException {
        this.setActive(false);
        if (forceClose) {
            if (this.iJavetEnginePool.getConfig().isGCBeforeEngineClose()) {
                ((V8Runtime)this.v8Runtime).lowMemoryNotification();
            }
            ((V8Runtime)this.v8Runtime).close(true);
        } else {
            this.iJavetEnginePool.releaseEngine(this);
        }
    }

    @Override
    public JavetEngineConfig getConfig() {
        return this.iJavetEnginePool.getConfig();
    }

    @Override
    public V8Guard getGuard() {
        return this.getGuard(this.iJavetEnginePool.getConfig().getDefaultEngineGuardTimeoutMillis());
    }

    @Override
    public V8Guard getGuard(long timeoutMillis) {
        return ((V8Runtime)this.v8Runtime).getGuard(timeoutMillis);
    }

    public int getIndex() {
        return this.index;
    }

    protected ZonedDateTime getUTCNow() {
        return JavetDateTimeUtils.getUTCNow();
    }

    protected JavetEngineUsage getUsage() {
        return this.usage;
    }

    @Override
    public R getV8Runtime() throws JavetException {
        this.setActive(true);
        return this.v8Runtime;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isClosed() {
        return this.v8Runtime == null || ((V8Runtime)this.v8Runtime).isClosed();
    }

    @Override
    public void resetContext() throws JavetException {
        ((V8Runtime)this.v8Runtime).resetContext();
        this.usage.reset();
    }

    @Override
    public void resetIsolate() throws JavetException {
        ((V8Runtime)this.v8Runtime).resetIsolate();
        this.usage.reset();
    }

    @Override
    public void sendGCNotification() {
        ((V8Runtime)this.v8Runtime).lowMemoryNotification();
    }

    protected void setActive(boolean active) {
        this.active = active;
        this.touchLastActiveZonedDateTime();
    }

    void setIndex(int index) {
        assert (index >= 0) : "Engine index must be no less than 0.";
        assert (index < this.iJavetEnginePool.getConfig().getPoolMaxSize()) : "Engine index must be less than " + this.iJavetEnginePool.getConfig().getPoolMaxSize() + ".";
        this.index = index;
    }

    protected void touchLastActiveZonedDateTime() {
        this.usage.setLastActiveZonedDatetime(this.getUTCNow());
    }
}

