/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.virtual;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetClosable;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.converters.IJavetConverter;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.values.V8Value;
import java.util.Objects;

public class V8VirtualValue
implements IJavetClosable {
    protected boolean converted;
    protected V8Value value;

    public V8VirtualValue(V8Runtime v8Runtime, IJavetConverter converter, Object object) throws JavetException {
        Objects.requireNonNull(v8Runtime);
        if (object instanceof V8Value) {
            this.converted = false;
            this.value = (V8Value)object;
        } else {
            this.converted = true;
            this.value = converter == null ? v8Runtime.toV8Value(object) : converter.toV8Value(v8Runtime, object);
        }
    }

    @Override
    public void close() throws JavetException {
        if (this.converted) {
            JavetResourceUtils.safeClose((Object)this.value);
        }
        this.value = null;
    }

    public <T extends V8Value> T get() {
        return (T)this.value;
    }

    @Override
    public boolean isClosed() {
        return this.value == null || this.value.isClosed();
    }
}

