/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop;

import com.caoccao.javet.enums.JSRuntimeType;
import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetLogger;
import com.caoccao.javet.interop.IV8Native;
import com.caoccao.javet.interop.JavetClassLoader;
import com.caoccao.javet.interop.NodeRuntime;
import com.caoccao.javet.interop.V8Guard;
import com.caoccao.javet.interop.V8Notifier;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.monitoring.V8SharedMemoryStatistics;
import com.caoccao.javet.interop.monitoring.V8StatisticsFuture;
import com.caoccao.javet.interop.options.RuntimeOptions;
import com.caoccao.javet.utils.JavetDateTimeUtils;
import com.caoccao.javet.utils.JavetDefaultLogger;
import com.caoccao.javet.utils.SimpleMap;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class V8Host {
    private static final long INVALID_HANDLE = 0L;
    private static boolean libraryReloadable = false;
    private static volatile double memoryUsageThresholdRatio = 0.7;
    private final JSRuntimeType jsRuntimeType;
    private final IJavetLogger logger;
    private final V8GuardDaemon v8GuardDaemon;
    private final V8Notifier v8Notifier;
    private final ConcurrentHashMap<Long, V8Runtime> v8RuntimeMap;
    private final V8StatisticsFutureDaemon v8StatisticsFutureDaemon;
    private boolean isolateCreated;
    private JavetClassLoader javetClassLoader;
    private JavetException lastException;
    private volatile boolean libraryLoaded;
    private Thread threadV8GuardDaemon;
    private Thread threadV8StatisticsFutureDaemon;
    private IV8Native v8Native;

    private V8Host(JSRuntimeType jsRuntimeType) {
        Objects.requireNonNull(jsRuntimeType);
        this.javetClassLoader = null;
        this.lastException = null;
        this.libraryLoaded = false;
        this.logger = new JavetDefaultLogger(this.getClass().getName());
        this.v8RuntimeMap = new ConcurrentHashMap();
        this.v8Native = null;
        this.isolateCreated = false;
        this.jsRuntimeType = jsRuntimeType;
        this.v8GuardDaemon = new V8GuardDaemon();
        this.v8StatisticsFutureDaemon = new V8StatisticsFutureDaemon();
        this.threadV8GuardDaemon = null;
        this.threadV8StatisticsFutureDaemon = null;
        this.loadLibrary();
        this.v8Notifier = new V8Notifier(this.v8RuntimeMap);
    }

    public static V8Host getInstance(JSRuntimeType jsRuntimeType) {
        if (Objects.requireNonNull(jsRuntimeType).isNode()) {
            return V8Host.getNodeInstance();
        }
        return V8Host.getV8Instance();
    }

    public static double getMemoryUsageThresholdRatio() {
        return memoryUsageThresholdRatio;
    }

    public static V8Host getNodeInstance() {
        return NodeInstanceHolder.INSTANCE;
    }

    public static V8Host getV8Instance() {
        return V8InstanceHolder.INSTANCE;
    }

    public static boolean isLibraryReloadable() {
        return libraryReloadable;
    }

    public static void setLibraryReloadable(boolean libraryReloadable) {
        V8Host.libraryReloadable = libraryReloadable;
    }

    private static void setMemoryUsageThreshold() {
        if (memoryUsageThresholdRatio > 0.0) {
            MemoryPoolMXBean heapMemoryPoolMXBean = null;
            List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
                if (memoryPoolMXBean.getType() != MemoryType.HEAP || !memoryPoolMXBean.isUsageThresholdSupported()) continue;
                heapMemoryPoolMXBean = memoryPoolMXBean;
                break;
            }
            if (heapMemoryPoolMXBean != null) {
                long memoryUsageThreshold = (long)Math.floor((double)heapMemoryPoolMXBean.getUsage().getMax() * memoryUsageThresholdRatio);
                heapMemoryPoolMXBean.setUsageThreshold(memoryUsageThreshold);
            }
        }
    }

    public static void setMemoryUsageThresholdRatio(double memoryUsageThresholdRatio) {
        assert (0.0 <= memoryUsageThresholdRatio && memoryUsageThresholdRatio < 1.0);
        V8Host.memoryUsageThresholdRatio = memoryUsageThresholdRatio;
    }

    public void clearInternalStatistic() {
        this.v8Native.clearInternalStatistic();
    }

    public void closeV8Runtime(V8Runtime v8Runtime) {
        long handle;
        if (!this.libraryLoaded) {
            return;
        }
        if (v8Runtime != null && (handle = v8Runtime.getHandle()) != 0L && this.v8RuntimeMap.containsKey(handle)) {
            this.v8Native.closeV8Runtime(handle);
            this.v8RuntimeMap.remove(handle);
        }
    }

    public <R extends V8Runtime> R createV8Runtime() throws JavetException {
        return this.createV8Runtime((RuntimeOptions<?>)this.getJSRuntimeType().getRuntimeOptions());
    }

    public <R extends V8Runtime> R createV8Runtime(RuntimeOptions<?> runtimeOptions) throws JavetException {
        return this.createV8Runtime(false, runtimeOptions);
    }

    public <R extends V8Runtime> R createV8Runtime(boolean pooled, RuntimeOptions<?> runtimeOptions) throws JavetException {
        assert (this.getJSRuntimeType().isRuntimeOptionsValid(runtimeOptions));
        if (!this.libraryLoaded) {
            if (this.lastException == null) {
                throw new JavetException(JavetError.LibraryNotLoaded, SimpleMap.of("reason", "there are unknown errors"));
            }
            throw this.lastException;
        }
        long handle = this.v8Native.createV8Runtime(runtimeOptions);
        this.isolateCreated = true;
        V8Runtime v8Runtime = this.jsRuntimeType.isNode() ? new NodeRuntime(this, handle, pooled, this.v8Native, runtimeOptions) : new V8Runtime(this, handle, pooled, this.v8Native, runtimeOptions);
        this.v8Native.registerV8Runtime(handle, v8Runtime);
        this.v8RuntimeMap.put(handle, v8Runtime);
        return (R)v8Runtime;
    }

    public V8Host disableGCNotification() {
        this.v8Notifier.unregisterListener();
        return this;
    }

    public V8Host enableGCNotification() {
        V8Host.setMemoryUsageThreshold();
        this.v8Notifier.registerListeners();
        return this;
    }

    public long[] getInternalStatistic() {
        return this.v8Native.getInternalStatistic();
    }

    public JSRuntimeType getJSRuntimeType() {
        return this.jsRuntimeType;
    }

    public String getJavetVersion() {
        return "3.1.5";
    }

    public JavetException getLastException() {
        return this.lastException;
    }

    public IJavetLogger getLogger() {
        return this.logger;
    }

    public long getSleepIntervalMillis() {
        return this.v8GuardDaemon.getSleepIntervalMillis();
    }

    V8GuardDaemon getV8GuardDaemon() {
        return this.v8GuardDaemon;
    }

    IV8Native getV8Native() {
        return this.v8Native;
    }

    public int getV8RuntimeCount() {
        return this.v8RuntimeMap.size();
    }

    public V8SharedMemoryStatistics getV8SharedMemoryStatistics() {
        return (V8SharedMemoryStatistics)this.v8Native.getV8SharedMemoryStatistics();
    }

    public boolean isIsolateCreated() {
        return this.isolateCreated;
    }

    public boolean isLibraryLoaded() {
        return this.libraryLoaded;
    }

    public synchronized boolean loadLibrary() {
        if (!this.libraryLoaded) {
            try {
                this.logger.logDebug("[{0}] Loading library.", this.jsRuntimeType.getName());
                this.javetClassLoader = new JavetClassLoader(this.getClass().getClassLoader(), this.jsRuntimeType);
                this.javetClassLoader.load();
                this.v8Native = this.javetClassLoader.getNative();
                this.libraryLoaded = true;
                this.isolateCreated = false;
                this.threadV8GuardDaemon = new Thread(this.v8GuardDaemon);
                this.threadV8GuardDaemon.setDaemon(true);
                this.threadV8GuardDaemon.start();
                this.v8StatisticsFutureDaemon.setV8Native(this.v8Native);
                this.threadV8StatisticsFutureDaemon = new Thread(this.v8StatisticsFutureDaemon);
                this.threadV8StatisticsFutureDaemon.setDaemon(true);
                this.threadV8StatisticsFutureDaemon.start();
            }
            catch (JavetException e) {
                this.logger.logError(e, "Failed to load Javet lib with error {0}.", e.getMessage());
                this.lastException = e;
            }
        }
        return this.libraryLoaded;
    }

    void offerV8StatisticsFuture(V8StatisticsFuture<?> v8StatisticsFuture) {
        this.v8StatisticsFutureDaemon.getV8StatisticsFutureQueue().offer(Objects.requireNonNull(v8StatisticsFuture));
    }

    public void setSleepIntervalMillis(long sleepIntervalMillis) {
        this.v8GuardDaemon.setSleepIntervalMillis(sleepIntervalMillis);
    }

    public synchronized boolean unloadLibrary() {
        if (this.libraryLoaded && this.v8RuntimeMap.isEmpty()) {
            this.logger.logDebug("[{0}] Unloading library.", this.jsRuntimeType.getName());
            this.threadV8GuardDaemon.interrupt();
            this.threadV8GuardDaemon = null;
            this.v8GuardDaemon.getV8GuardQueue().clear();
            this.threadV8StatisticsFutureDaemon.interrupt();
            this.threadV8StatisticsFutureDaemon = null;
            this.v8StatisticsFutureDaemon.purgeV8StatisticsFutureQueue();
            this.v8StatisticsFutureDaemon.setV8Native(null);
            this.isolateCreated = false;
            this.v8Native = null;
            this.javetClassLoader = null;
            System.gc();
            System.runFinalization();
            this.libraryLoaded = false;
            this.lastException = null;
        }
        return !this.libraryLoaded;
    }

    static class V8StatisticsFutureDaemon
    implements Runnable {
        private static final long SLEEP_IN_MILLIS = 1000L;
        private static final long TIMEOUT_IN_SECONDS = 60L;
        private final ConcurrentLinkedQueue<V8StatisticsFuture<?>> v8StatisticsFutureQueue = new ConcurrentLinkedQueue();
        private IV8Native v8Native = null;

        public ConcurrentLinkedQueue<V8StatisticsFuture<?>> getV8StatisticsFutureQueue() {
            return this.v8StatisticsFutureQueue;
        }

        public void purgeV8StatisticsFutureQueue() {
            while (!this.v8StatisticsFutureQueue.isEmpty()) {
                V8StatisticsFuture<?> v8StatisticsFuture = this.v8StatisticsFutureQueue.poll();
                if (v8StatisticsFuture.isDone()) continue;
                this.v8Native.removeRawPointer(v8StatisticsFuture.getHandle(), v8StatisticsFuture.getRawPointerType().getId());
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    ZonedDateTime purgeDateTime;
                    if (this.v8StatisticsFutureQueue.isEmpty()) {
                        TimeUnit.MILLISECONDS.sleep(1000L);
                        continue;
                    }
                    V8StatisticsFuture<?> v8StatisticsFuture = this.v8StatisticsFutureQueue.peek();
                    if (v8StatisticsFuture.isDone()) {
                        this.v8StatisticsFutureQueue.poll();
                        continue;
                    }
                    ZonedDateTime now = JavetDateTimeUtils.getUTCNow();
                    Duration duration = Duration.between(now, purgeDateTime = v8StatisticsFuture.getCreationDateTime().plusSeconds(60L));
                    if (duration.isNegative()) {
                        this.v8Native.removeRawPointer(v8StatisticsFuture.getHandle(), v8StatisticsFuture.getRawPointerType().getId());
                        this.v8StatisticsFutureQueue.poll();
                        continue;
                    }
                    TimeUnit.MILLISECONDS.sleep(duration.toMillis());
                }
            }
            catch (InterruptedException ignored) {
                return;
            }
        }

        public void setV8Native(IV8Native v8Native) {
            this.v8Native = v8Native;
        }
    }

    private static class V8InstanceHolder {
        private static final V8Host INSTANCE = new V8Host(JSRuntimeType.V8);

        private V8InstanceHolder() {
        }
    }

    static class V8GuardDaemon
    implements Runnable {
        private static final long DEFAULT_SLEEP_INTERVAL_MILLIS = 5L;
        private static final int INITIAL_CAPACITY = 64;
        private static final boolean IS_IN_DEBUG_MODE = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
        private final PriorityBlockingQueue<V8Guard> v8GuardQueue = new PriorityBlockingQueue(64, (g1, g2) -> (int)(g1.getEndTimeMillis() - g2.getEndTimeMillis()));
        private long sleepIntervalMillis = 5L;

        public long getSleepIntervalMillis() {
            return this.sleepIntervalMillis;
        }

        public PriorityBlockingQueue<V8Guard> getV8GuardQueue() {
            return this.v8GuardQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    V8Guard v8Guard = this.v8GuardQueue.take();
                    long now = System.currentTimeMillis();
                    if (now > v8Guard.getEndTimeMillis()) {
                        if (!v8Guard.isDebugModeEnabled() && IS_IN_DEBUG_MODE) continue;
                        V8Runtime v8Runtime = v8Guard.getV8Runtime();
                        Object object = v8Runtime.getCloseLock();
                        synchronized (object) {
                            if (!v8Runtime.isClosed() && v8Runtime.isInUse()) {
                                v8Runtime.terminateExecution();
                                v8Runtime.getLogger().logWarn("Execution was terminated after {0}ms.", now - v8Guard.getStartTimeMillis());
                            }
                            continue;
                        }
                    }
                    this.v8GuardQueue.add(v8Guard);
                    long sleepMillis = Math.min(v8Guard.getEndTimeMillis() - now, this.sleepIntervalMillis);
                    TimeUnit.MILLISECONDS.sleep(sleepMillis);
                }
            }
            catch (InterruptedException ignored) {
                return;
            }
        }

        public void setSleepIntervalMillis(long sleepIntervalMillis) {
            assert (sleepIntervalMillis > 0L) : "sleepIntervalMillis must be greater than 0";
            this.sleepIntervalMillis = sleepIntervalMillis;
        }
    }

    private static class NodeInstanceHolder {
        private static final V8Host INSTANCE = new V8Host(JSRuntimeType.Node);

        private NodeInstanceHolder() {
        }
    }
}

