/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interception.jvm;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interception.BaseJavetDirectCallableInterceptor;
import com.caoccao.javet.interfaces.IJavetUniFunction;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.interop.converters.JavetProxyConverter;
import com.caoccao.javet.interop.proxy.IJavetDirectProxyHandler;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.utils.StringUtils;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JavetJVMInterceptor
extends BaseJavetDirectCallableInterceptor {
    public static final String DEFAULT_NAME = "javet";
    protected static final String ERROR_THE_CONVERTER_MUST_BE_INSTANCE_OF_JAVET_PROXY_CONVERTER = "The converter must be instance of JavetProxyConverter.";
    protected static final JavetProxyConverter JAVET_PROXY_CONVERTER = new JavetProxyConverter();
    protected static final String JS_PROPERTY_PACKAGE = "package";
    protected static final String JS_PROPERTY_V8 = "v8";
    protected String name;

    public JavetJVMInterceptor(V8Runtime v8Runtime) {
        super(v8Runtime);
        assert (v8Runtime.getConverter() instanceof JavetProxyConverter) : "The converter must be instance of JavetProxyConverter.";
        this.name = DEFAULT_NAME;
    }

    @Override
    public JavetCallbackContext[] getCallbackContexts() {
        return new JavetCallbackContext[]{new JavetCallbackContext(JS_PROPERTY_V8, (Object)this, JavetCallbackType.DirectCallGetterAndNoThis, () -> new JavetV8(this.v8Runtime).toV8Value()), new JavetCallbackContext(JS_PROPERTY_PACKAGE, (Object)this, JavetCallbackType.DirectCallGetterAndNoThis, () -> new JavetVirtualPackage(this.v8Runtime, "").toV8Value())};
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean register(IV8ValueObject ... iV8ValueObjects) throws JavetException {
        boolean successful = true;
        try (V8ValueObject v8ValueObject = this.v8Runtime.createV8ValueObject();){
            v8ValueObject.bind(this);
            for (IV8ValueObject iV8ValueObject : iV8ValueObjects) {
                successful = iV8ValueObject.set((Object)DEFAULT_NAME, (Object)v8ValueObject) & successful;
            }
            boolean bl = successful;
            return bl;
        }
    }

    public void setName(String name) {
        this.name = Objects.requireNonNull(name);
    }

    @Override
    public boolean unregister(IV8ValueObject ... iV8ValueObjects) throws JavetException {
        boolean successful = true;
        for (IV8ValueObject iV8ValueObject : iV8ValueObjects) {
            successful = iV8ValueObject.delete(DEFAULT_NAME) & successful;
        }
        return successful;
    }

    static class JavetVirtualPackage
    extends BaseJavetPackage {
        protected String packageName;

        public JavetVirtualPackage(V8Runtime v8Runtime, String packageName) {
            super(v8Runtime);
            this.packageName = packageName;
        }

        @Override
        public String getName() {
            return this.packageName;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }

    static class JavetV8
    implements IJavetDirectProxyHandler<Exception> {
        protected Map<String, IJavetUniFunction<String, ? extends V8Value, Exception>> stringGetterMap;
        protected V8Runtime v8Runtime;

        public JavetV8(V8Runtime v8Runtime) {
            this.v8Runtime = v8Runtime;
        }

        @Override
        public V8Runtime getV8Runtime() {
            return this.v8Runtime;
        }

        @Override
        public Map<String, IJavetUniFunction<String, ? extends V8Value, Exception>> proxyGetStringGetterMap() {
            if (this.stringGetterMap == null) {
                this.stringGetterMap = new HashMap<String, IJavetUniFunction<String, ? extends V8Value, Exception>>();
                this.stringGetterMap.put("gc", propertyName -> this.v8Runtime.createV8ValueFunction(new JavetCallbackContext((String)propertyName, (Object)this, JavetCallbackType.DirectCallNoThisAndNoResult, v8Values -> this.v8Runtime.lowMemoryNotification())));
            }
            return this.stringGetterMap;
        }

        public V8Value toV8Value() throws JavetException {
            return JAVET_PROXY_CONVERTER.toV8Value(this.v8Runtime, this);
        }
    }

    static class JavetPackage
    extends BaseJavetPackage {
        protected Package namedPackage;

        public JavetPackage(V8Runtime v8Runtime, Package namedPackage) {
            super(v8Runtime);
            this.namedPackage = namedPackage;
            this.stringGetterMap = null;
        }

        @Override
        public String getName() {
            return this.namedPackage.getName();
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Map<String, IJavetUniFunction<String, ? extends V8Value, Exception>> proxyGetStringGetterMap() {
            if (this.stringGetterMap == null) {
                this.stringGetterMap = super.proxyGetStringGetterMap();
                this.stringGetterMap.put(".implementationTitle", propertyName -> this.v8Runtime.createV8ValueString(this.namedPackage.getImplementationTitle()));
                this.stringGetterMap.put(".implementationVersion", propertyName -> this.v8Runtime.createV8ValueString(this.namedPackage.getImplementationVersion()));
                this.stringGetterMap.put(".implementationVendor", propertyName -> this.v8Runtime.createV8ValueString(this.namedPackage.getImplementationVendor()));
                this.stringGetterMap.put(".sealed", propertyName -> this.v8Runtime.createV8ValueBoolean(this.namedPackage.isSealed()));
                this.stringGetterMap.put(".specificationTitle", propertyName -> this.v8Runtime.createV8ValueString(this.namedPackage.getSpecificationTitle()));
                this.stringGetterMap.put(".specificationVersion", propertyName -> this.v8Runtime.createV8ValueString(this.namedPackage.getSpecificationVersion()));
                this.stringGetterMap.put(".specificationVendor", propertyName -> this.v8Runtime.createV8ValueString(this.namedPackage.getSpecificationVendor()));
            }
            return this.stringGetterMap;
        }
    }

    static abstract class BaseJavetPackage
    implements IJavetDirectProxyHandler<Exception> {
        protected Map<String, IJavetUniFunction<String, ? extends V8Value, Exception>> stringGetterMap;
        protected V8Runtime v8Runtime;

        public BaseJavetPackage(V8Runtime v8Runtime) {
            this.v8Runtime = v8Runtime;
        }

        public abstract String getName();

        @Override
        public V8Runtime getV8Runtime() {
            return this.v8Runtime;
        }

        public abstract boolean isValid();

        @Override
        public V8Value proxyGet(V8Value target, V8Value property, V8Value receiver) throws JavetException, Exception {
            String childName;
            V8Value v8Value = IJavetDirectProxyHandler.super.proxyGet(target, property, receiver);
            if (v8Value == null && property instanceof V8ValueString && !StringUtils.isEmpty(childName = (String)((V8ValueString)property).getValue())) {
                String name = StringUtils.isEmpty(this.getName()) ? childName : this.getName() + "." + childName;
                try {
                    Class<?> clazz = Class.forName(name);
                    v8Value = JAVET_PROXY_CONVERTER.toV8Value(this.v8Runtime, clazz);
                }
                catch (Throwable ignored) {
                    Package namedPackage = Package.getPackage(name);
                    v8Value = namedPackage != null ? new JavetPackage(this.v8Runtime, namedPackage).toV8Value() : new JavetVirtualPackage(this.v8Runtime, name).toV8Value();
                }
            }
            return v8Value;
        }

        @Override
        public Map<String, IJavetUniFunction<String, ? extends V8Value, Exception>> proxyGetStringGetterMap() {
            if (this.stringGetterMap == null) {
                this.stringGetterMap = new HashMap<String, IJavetUniFunction<String, ? extends V8Value, Exception>>();
                this.stringGetterMap.put(".getPackages", propertyName -> this.v8Runtime.createV8ValueFunction(new JavetCallbackContext((String)propertyName, (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> {
                    String prefix = this.getName() + ".";
                    List packages = Stream.of(Package.getPackages()).filter(p -> p.getName().startsWith(prefix)).filter(p -> p.getName().substring(prefix.length()).contains(".")).collect(Collectors.toList());
                    ArrayList<V8Value> results = new ArrayList<V8Value>(packages.size());
                    try {
                        for (Package p2 : packages) {
                            results.add(new JavetPackage(this.v8Runtime, p2).toV8Value());
                        }
                        V8ValueArray v8ValueArray = V8ValueUtils.createV8ValueArray(this.v8Runtime, results.toArray());
                        return v8ValueArray;
                    }
                    finally {
                        JavetResourceUtils.safeClose(results);
                    }
                })));
                this.stringGetterMap.put(".name", propertyName -> this.v8Runtime.createV8ValueString(this.getName()));
                this.stringGetterMap.put(".valid", propertyName -> this.v8Runtime.createV8ValueBoolean(this.isValid()));
            }
            return this.stringGetterMap;
        }

        public V8Value toV8Value() throws JavetException {
            return JAVET_PROXY_CONVERTER.toV8Value(this.v8Runtime, this);
        }
    }
}

