/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetUniConsumer;
import com.caoccao.javet.interfaces.IJavetUniIndexedConsumer;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueNull;
import com.caoccao.javet.values.primitive.V8ValuePrimitive;
import com.caoccao.javet.values.primitive.V8ValueUndefined;
import com.caoccao.javet.values.reference.IV8ValueObject;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;

public interface IV8ValueArray
extends IV8ValueObject {
    public static final String FUNCTION_FLAT = "flat";
    public static final String FUNCTION_SHIFT = "shift";
    public static final String FUNCTION_UNSHIFT = "unshift";
    public static final String FUNCTION_POP = "pop";
    public static final String FUNCTION_PUSH = "push";

    public int batchGet(V8Value[] var1, int var2, int var3) throws JavetException;

    default public <T extends V8Value> T[] batchGet() throws JavetException {
        int length = this.getLength();
        Object[] v8Values = new V8Value[length];
        if (length > 0) {
            try {
                this.batchGet((V8Value[])v8Values, 0, length);
            }
            catch (Throwable t) {
                JavetResourceUtils.safeClose((V8Value[])v8Values);
                Arrays.fill(v8Values, null);
                throw t;
            }
        }
        return v8Values;
    }

    default public IV8ValueArray flat() throws JavetException {
        return (IV8ValueArray)this.invoke(FUNCTION_FLAT, new V8Value[0]);
    }

    default public IV8ValueArray flat(int depth) throws JavetException {
        return (IV8ValueArray)this.invoke(FUNCTION_FLAT, this.getV8Runtime().createV8ValueInteger(depth));
    }

    public <Value extends V8Value, E extends Throwable> int forEach(IJavetUniConsumer<Value, E> var1, int var2) throws JavetException, E;

    public <Value extends V8Value, E extends Throwable> int forEach(IJavetUniIndexedConsumer<Value, E> var1, int var2) throws JavetException, E;

    public <T extends V8Value> T get(int var1) throws JavetException;

    public List<Integer> getKeys() throws JavetException;

    public int getLength() throws JavetException;

    default public <T extends V8Value> T pop() throws JavetException {
        return this.invoke(FUNCTION_POP, new V8Value[0]);
    }

    default public BigInteger popBigInteger() throws JavetException {
        return (BigInteger)this.popPrimitive();
    }

    default public Boolean popBoolean() throws JavetException {
        return (Boolean)this.popPrimitive();
    }

    default public Double popDouble() throws JavetException {
        return (Double)this.popPrimitive();
    }

    default public Integer popInteger() throws JavetException {
        return (Integer)this.popPrimitive();
    }

    default public Long popLong() throws JavetException {
        return (Long)this.popPrimitive();
    }

    default public V8ValueNull popNull() throws JavetException {
        return (V8ValueNull)this.pop();
    }

    default public <T> T popObject() throws JavetException {
        try {
            return this.getV8Runtime().toObject(this.pop(), true);
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <R, T extends V8ValuePrimitive<R>> R popPrimitive() throws JavetException {
        try (T v8Value = this.pop();){
            Object Primitive = ((V8ValuePrimitive)v8Value).getValue();
            return (R)Primitive;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable6) {
            return null;
        }
    }

    default public String popString() throws JavetException {
        return (String)this.popPrimitive();
    }

    default public V8ValueUndefined popUndefined() throws JavetException {
        return (V8ValueUndefined)this.pop();
    }

    default public ZonedDateTime popZonedDateTime() throws JavetException {
        return (ZonedDateTime)this.popPrimitive();
    }

    default public int push(Object ... objects) throws JavetException {
        return this.invokeInteger(FUNCTION_PUSH, objects);
    }

    default public int pushNull() throws JavetException {
        return this.push(this.getV8Runtime().createV8ValueNull());
    }

    default public int pushUndefined() throws JavetException {
        return this.push(this.getV8Runtime().createV8ValueUndefined());
    }

    default public <T extends V8Value> T shift() throws JavetException {
        return this.invoke(FUNCTION_SHIFT, new V8Value[0]);
    }

    default public BigInteger shiftBigInteger() throws JavetException {
        return (BigInteger)this.shiftPrimitive();
    }

    default public Boolean shiftBoolean() throws JavetException {
        return (Boolean)this.shiftPrimitive();
    }

    default public Double shiftDouble() throws JavetException {
        return (Double)this.shiftPrimitive();
    }

    default public Integer shiftInteger() throws JavetException {
        return (Integer)this.shiftPrimitive();
    }

    default public Long shiftLong() throws JavetException {
        return (Long)this.shiftPrimitive();
    }

    default public V8ValueNull shiftNull() throws JavetException {
        return (V8ValueNull)this.shift();
    }

    default public <T> T shiftObject() throws JavetException {
        try {
            return this.getV8Runtime().toObject(this.shift(), true);
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <R, T extends V8ValuePrimitive<R>> R shiftPrimitive() throws JavetException {
        try (T v8Value = this.shift();){
            Object Primitive = ((V8ValuePrimitive)v8Value).getValue();
            return (R)Primitive;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable6) {
            return null;
        }
    }

    default public String shiftString() throws JavetException {
        return (String)this.shiftPrimitive();
    }

    default public V8ValueUndefined shiftUndefined() throws JavetException {
        return (V8ValueUndefined)this.shift();
    }

    default public ZonedDateTime shiftZonedDateTime() throws JavetException {
        return (ZonedDateTime)this.shiftPrimitive();
    }

    default public V8Value[] toArray() throws JavetException {
        return this.batchGet();
    }

    default public int unshift(Object ... objects) throws JavetException {
        return this.invokeInteger(FUNCTION_UNSHIFT, objects);
    }

    default public int unshiftNull() throws JavetException {
        return this.unshift(this.getV8Runtime().createV8ValueNull());
    }

    default public int unshiftUndefined() throws JavetException {
        return this.unshift(this.getV8Runtime().createV8ValueUndefined());
    }
}

