/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetLogger;
import com.caoccao.javet.interop.IV8InspectorListener;
import com.caoccao.javet.interop.IV8Native;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.utils.SimpleList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class V8Inspector {
    private final List<IV8InspectorListener> listeners;
    private final String name;
    private final IV8Native v8Native;
    private final V8Runtime v8Runtime;
    private IJavetLogger logger;

    V8Inspector(V8Runtime v8Runtime, String name, IV8Native v8Native) {
        this.logger = v8Runtime.getLogger();
        this.name = name;
        this.listeners = new ArrayList<IV8InspectorListener>();
        this.v8Runtime = v8Runtime;
        this.v8Native = v8Native;
        v8Native.createV8Inspector(v8Runtime.getHandle(), this);
    }

    public void addListeners(IV8InspectorListener ... listeners) {
        Collections.addAll(this.listeners, (Object[])Objects.requireNonNull(listeners));
    }

    public void flushProtocolNotifications() {
        this.logger.logDebug("Receiving flushProtocolNotifications", new Object[0]);
        for (IV8InspectorListener listener : this.listeners) {
            try {
                listener.flushProtocolNotifications();
            }
            catch (Throwable t) {
                this.logger.logError(t, t.getMessage(), new Object[0]);
            }
        }
    }

    public IJavetLogger getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.name;
    }

    public void receiveNotification(String message) {
        this.logger.logDebug("Receiving notification: {0}", message);
        for (IV8InspectorListener listener : this.listeners) {
            try {
                listener.receiveNotification(message);
            }
            catch (Throwable t) {
                this.logger.logError(t, t.getMessage(), new Object[0]);
            }
        }
    }

    public void receiveResponse(String message) {
        this.logger.logDebug("Receiving response: {0}", message);
        for (IV8InspectorListener listener : this.listeners) {
            try {
                listener.receiveResponse(message);
            }
            catch (Throwable t) {
                this.logger.logError(t, t.getMessage(), new Object[0]);
            }
        }
    }

    public void removeListeners(IV8InspectorListener ... listeners) {
        this.listeners.removeAll(SimpleList.of(listeners));
    }

    public void runIfWaitingForDebugger(int contextGroupId) {
        this.logger.logDebug("Receiving runIfWaitingForDebugger(): {0}", Integer.toString(contextGroupId));
        for (IV8InspectorListener listener : this.listeners) {
            try {
                listener.runIfWaitingForDebugger(contextGroupId);
            }
            catch (Throwable t) {
                this.logger.logError(t, t.getMessage(), new Object[0]);
            }
        }
    }

    public void sendRequest(String message) throws JavetException {
        this.logger.logDebug("Sending request: {0}", message);
        for (IV8InspectorListener listener : this.listeners) {
            try {
                listener.sendRequest(message);
            }
            catch (Throwable t) {
                this.logger.logError(t, t.getMessage(), new Object[0]);
            }
        }
        this.v8Native.v8InspectorSend(this.v8Runtime.getHandle(), message);
    }

    public void setLogger(IJavetLogger logger) {
        Objects.requireNonNull(logger);
        this.logger = logger;
    }
}

