/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.V8ValueErrorType;
import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.utils.StringUtils;
import com.caoccao.javet.values.reference.V8ValueObject;

public class V8ValueError
extends V8ValueObject {
    public static final String MESSAGE = "message";
    public static final String STACK = "stack";
    protected static final String METHOD_NAME_CONSTRUCTOR = "constructor";
    protected V8ValueErrorType optionalType = null;

    V8ValueError(V8Runtime v8Runtime, long handle) throws JavetException {
        super(v8Runtime, handle);
    }

    public V8ValueErrorType getErrorType() {
        if (this.optionalType == null) {
            this.optionalType = V8ValueErrorType.UnknownError;
            try (Object v8Value = this.get(METHOD_NAME_CONSTRUCTOR);){
                String constructorFunction = v8Value.toString();
                if (StringUtils.isNotEmpty(constructorFunction)) {
                    int startIndex = constructorFunction.indexOf(" ") + 1;
                    int endIndex = constructorFunction.indexOf("(");
                    if (startIndex > 0 && endIndex > startIndex) {
                        String constructorName = constructorFunction.substring(startIndex, endIndex);
                        this.optionalType = V8ValueErrorType.parse(constructorName);
                    }
                }
            }
            catch (Throwable ignored) {
                ignored.printStackTrace(System.err);
            }
        }
        return this.optionalType;
    }

    public String getMessage() throws JavetException {
        return this.getPropertyString(MESSAGE);
    }

    public String getStack() throws JavetException {
        return this.getPropertyString(STACK);
    }

    @Override
    public V8ValueReferenceType getType() {
        return V8ValueReferenceType.Error;
    }

    public boolean setStack(String stack) throws JavetException {
        return this.setProperty(STACK, stack);
    }
}

