/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.primitive;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.IV8ValuePrimitiveValue;
import com.caoccao.javet.values.primitive.V8ValuePrimitive;
import com.caoccao.javet.values.reference.V8ValueBooleanObject;

public final class V8ValueBoolean
extends V8ValuePrimitive<Boolean>
implements IV8ValuePrimitiveValue<V8ValueBooleanObject> {
    public static final String FALSE = "false";
    public static final String TRUE = "true";

    public V8ValueBoolean(V8Runtime v8Runtime) throws JavetException {
        this(v8Runtime, false);
    }

    public V8ValueBoolean(V8Runtime v8Runtime, boolean value) throws JavetException {
        super(v8Runtime, value);
    }

    @Override
    public boolean asBoolean() {
        return (Boolean)this.value;
    }

    @Override
    public int asInt() {
        return (Boolean)this.value != false ? 1 : 0;
    }

    public V8ValueBoolean toClone(boolean referenceCopy) throws JavetException {
        return this;
    }

    @Override
    public V8ValueBooleanObject toObject() throws JavetException {
        return this.checkV8Runtime().createV8ValueBooleanObject((Boolean)this.value);
    }

    public boolean toPrimitive() {
        return (Boolean)this.value;
    }

    @Override
    public String toString() {
        return (Boolean)this.value != false ? TRUE : FALSE;
    }
}

