/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.interop.proxy.BaseJavetReflectionProxyHandler;
import com.caoccao.javet.interop.proxy.IJavetReflectionObjectFactory;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

final class JavetReflectionProxyInterceptor {
    private static final String METHOD_NAME_INVOKE = "invoke";
    private final String jsMethodName;
    private final List<Method> methods;
    private final IJavetReflectionObjectFactory reflectionObjectFactory;
    private final Object targetObject;

    public JavetReflectionProxyInterceptor(IJavetReflectionObjectFactory reflectionObjectFactory, Object targetObject, String jsMethodName, List<Method> methods) {
        this.reflectionObjectFactory = reflectionObjectFactory;
        this.jsMethodName = jsMethodName;
        this.methods = methods;
        this.targetObject = targetObject;
    }

    public JavetCallbackContext getCallbackContext() {
        return new JavetCallbackContext(METHOD_NAME_INVOKE, JavetCallbackType.DirectCallThisAndResult, this::invokeV8Value);
    }

    public String getJSMethodName() {
        return this.jsMethodName;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public Object invokeObject(V8ValueObject thisObject, V8Value ... v8Values) throws JavetException {
        try {
            return BaseJavetReflectionProxyHandler.execute(this.reflectionObjectFactory, this.targetObject, thisObject, this.methods, V8ValueUtils.convertToVirtualObjects(v8Values));
        }
        catch (JavetException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new JavetException(JavetError.CallbackMethodFailure, SimpleMap.of("methodName", this.jsMethodName, "message", e.getTargetException().getMessage()), e.getTargetException());
        }
        catch (Throwable t) {
            throw new JavetException(JavetError.CallbackMethodFailure, SimpleMap.of("methodName", this.jsMethodName, "message", t.getMessage()), t);
        }
    }

    public V8Value invokeV8Value(V8Value thisObject, V8Value ... v8Values) throws JavetException {
        return thisObject.getV8Runtime().toV8Value(this.invokeObject((V8ValueObject)thisObject, v8Values));
    }
}

