/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.options;

import com.caoccao.javet.utils.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;

public final class V8Flags {
    public static final String FLAG_ALLOW_NATIVES_SYNTAX = "--allow-natives-syntax";
    public static final String FLAG_EXPOSE_GC = "--expose-gc";
    public static final String FLAG_EXPOSE_INSPECTOR_SCRIPTS = "--expose-inspector-scripts";
    public static final String FLAG_INITIAL_HEAP_SIZE = "--initial-heap-size";
    public static final String FLAG_MAX_OLD_SPACE_SIZE = "--max-old-space-size";
    public static final String FLAG_MAX_HEAP_SIZE = "--max-heap-size";
    public static final String FLAG_TRACK_RETAINING_PATH = "--track-retaining-path";
    public static final String FLAG_USE_STRICT = "--use-strict";
    private static final String SPACE = " ";
    private boolean allowNativesSyntax = false;
    private String customFlags = null;
    private boolean exposeGC = false;
    private boolean exposeInspectorScripts = false;
    private int initialHeapSize = 0;
    private int maxHeapSize = 0;
    private int maxOldSpaceSize = 0;
    private boolean sealed = false;
    private boolean trackRetainingPath = false;
    private boolean useStrict = true;

    V8Flags() {
    }

    private String fromInteger(String flagName, int flagValue) {
        return MessageFormat.format("{0}={1}", flagName, Integer.toString(flagValue));
    }

    public String getCustomFlags() {
        return this.customFlags;
    }

    public int getInitialHeapSize() {
        return this.initialHeapSize;
    }

    public int getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public int getMaxOldSpaceSize() {
        return this.maxOldSpaceSize;
    }

    public boolean isAllowNativesSyntax() {
        return this.allowNativesSyntax;
    }

    public boolean isExposeGC() {
        return this.exposeGC;
    }

    public boolean isExposeInspectorScripts() {
        return this.exposeInspectorScripts;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public boolean isTrackRetainingPath() {
        return this.trackRetainingPath;
    }

    public boolean isUseStrict() {
        return this.useStrict;
    }

    public V8Flags seal() {
        if (!this.sealed) {
            this.sealed = true;
        }
        return this;
    }

    public V8Flags setAllowNativesSyntax(boolean allowNativesSyntax) {
        if (!this.sealed) {
            this.allowNativesSyntax = allowNativesSyntax;
        }
        return this;
    }

    public V8Flags setCustomFlags(String customFlags) {
        if (!this.sealed) {
            this.customFlags = customFlags == null ? null : customFlags.trim();
        }
        return this;
    }

    public V8Flags setExposeGC(boolean exposeGC) {
        if (!this.sealed) {
            this.exposeGC = exposeGC;
        }
        return this;
    }

    public V8Flags setExposeInspectorScripts(boolean exposeInspectorScripts) {
        if (!this.sealed) {
            this.exposeInspectorScripts = exposeInspectorScripts;
        }
        return this;
    }

    public V8Flags setInitialHeapSize(int initialHeapSize) {
        if (!this.sealed) {
            assert (initialHeapSize >= 0) : "Initial heap size must be no less than 0";
            this.initialHeapSize = initialHeapSize;
        }
        return this;
    }

    public V8Flags setMaxHeapSize(int maxHeapSize) {
        if (!this.sealed) {
            assert (maxHeapSize >= 0) : "Max heap size must be no less than 0";
            this.maxHeapSize = maxHeapSize;
        }
        return this;
    }

    public V8Flags setMaxOldSpaceSize(int maxOldSpaceSize) {
        if (!this.sealed) {
            assert (maxOldSpaceSize >= 0) : "Max old space size must be no less than 0";
            this.maxOldSpaceSize = maxOldSpaceSize;
        }
        return this;
    }

    public V8Flags setTrackRetainingPath(boolean trackRetainingPath) {
        if (!this.sealed) {
            this.trackRetainingPath = trackRetainingPath;
        }
        return this;
    }

    public V8Flags setUseStrict(boolean useStrict) {
        if (!this.sealed) {
            this.useStrict = useStrict;
        }
        return this;
    }

    public String toString() {
        ArrayList<String> tokens = new ArrayList<String>();
        if (this.allowNativesSyntax) {
            tokens.add(FLAG_ALLOW_NATIVES_SYNTAX);
        }
        if (this.exposeGC) {
            tokens.add(FLAG_EXPOSE_GC);
        }
        if (this.exposeInspectorScripts) {
            tokens.add(FLAG_EXPOSE_INSPECTOR_SCRIPTS);
        }
        if (this.initialHeapSize > 0) {
            tokens.add(this.fromInteger(FLAG_INITIAL_HEAP_SIZE, this.initialHeapSize));
        }
        if (this.maxHeapSize > 0) {
            tokens.add(this.fromInteger(FLAG_MAX_HEAP_SIZE, this.maxHeapSize));
        }
        if (this.maxOldSpaceSize > 0) {
            tokens.add(this.fromInteger(FLAG_MAX_OLD_SPACE_SIZE, this.maxOldSpaceSize));
        }
        if (this.useStrict) {
            tokens.add(FLAG_USE_STRICT);
        }
        if (this.trackRetainingPath) {
            tokens.add(FLAG_TRACK_RETAINING_PATH);
        }
        Collections.sort(tokens, String::compareTo);
        if (StringUtils.isNotEmpty(this.customFlags)) {
            tokens.add(this.customFlags);
        }
        return StringUtils.join((CharSequence)SPACE, tokens);
    }
}

