/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.executors;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.IV8Executable;
import com.caoccao.javet.interop.NodeRuntime;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.V8ScriptOrigin;
import com.caoccao.javet.node.modules.NodeModuleModule;
import com.caoccao.javet.node.modules.NodeModuleProcess;
import com.caoccao.javet.utils.JavetOSUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8Module;
import com.caoccao.javet.values.reference.V8Script;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.io.File;

public interface IV8Executor
extends IV8Executable {
    default public V8Module compileV8Module() throws JavetException {
        return this.compileV8Module(true);
    }

    public V8Module compileV8Module(boolean var1) throws JavetException;

    default public void compileV8ModuleVoid() throws JavetException {
        this.compileV8Module(false);
    }

    default public V8Script compileV8Script() throws JavetException {
        return this.compileV8Script(true);
    }

    public V8Script compileV8Script(boolean var1) throws JavetException;

    default public void compileV8ScriptVoid() throws JavetException {
        this.compileV8Script(false);
    }

    default public V8ValueFunction compileV8ValueFunction() throws JavetException {
        return this.compileV8ValueFunction(null, null);
    }

    default public V8ValueFunction compileV8ValueFunction(String[] arguments) throws JavetException {
        return this.compileV8ValueFunction(arguments, null);
    }

    public V8ValueFunction compileV8ValueFunction(String[] var1, V8ValueObject[] var2) throws JavetException;

    public byte[] getCachedData();

    default public String getResourceName() {
        return this.getV8ScriptOrigin().getResourceName();
    }

    public String getScriptString() throws JavetException;

    public V8Runtime getV8Runtime();

    public V8ScriptOrigin getV8ScriptOrigin();

    default public boolean isModule() {
        return this.getV8ScriptOrigin().isModule();
    }

    default public IV8Executor setModule(boolean module) {
        this.getV8ScriptOrigin().setModule(module);
        return this;
    }

    default public IV8Executor setResourceName(String resourceName) throws JavetException {
        this.getV8ScriptOrigin().setResourceName(resourceName);
        V8Runtime v8Runtime = this.getV8Runtime();
        if (v8Runtime.getJSRuntimeType().isNode() && !JavetOSUtils.IS_ANDROID) {
            NodeRuntime nodeRuntime = (NodeRuntime)v8Runtime;
            File resourceFile = new File(resourceName);
            File parentFile = resourceFile.getParentFile();
            nodeRuntime.getGlobalObject().set((Object)"__dirname", (Object)parentFile.getAbsolutePath());
            nodeRuntime.getGlobalObject().set((Object)"__filename", (Object)resourceFile.getAbsolutePath());
            nodeRuntime.getNodeModule(NodeModuleModule.class).setRequireRootDirectory(parentFile.getAbsoluteFile());
            nodeRuntime.getNodeModule(NodeModuleProcess.class).setWorkingDirectory(parentFile.getAbsolutePath());
        }
        return this;
    }

    @Override
    default public <T, V extends V8Value> T toObject(V v8Value) throws JavetException {
        return this.getV8Runtime().toObject(v8Value);
    }

    @Override
    default public <T, V extends V8Value> V toV8Value(T object) throws JavetException {
        return this.getV8Runtime().toV8Value(object);
    }
}

