/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop;

import com.caoccao.javet.enums.V8ValueErrorType;
import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetClosable;
import com.caoccao.javet.interop.IV8Creatable;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBigInteger;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.primitive.V8ValueDouble;
import com.caoccao.javet.values.primitive.V8ValueInteger;
import com.caoccao.javet.values.primitive.V8ValueLong;
import com.caoccao.javet.values.primitive.V8ValueNull;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.primitive.V8ValueUndefined;
import com.caoccao.javet.values.primitive.V8ValueZonedDateTime;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.V8Module;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueArrayBuffer;
import com.caoccao.javet.values.reference.V8ValueBooleanObject;
import com.caoccao.javet.values.reference.V8ValueDataView;
import com.caoccao.javet.values.reference.V8ValueDoubleObject;
import com.caoccao.javet.values.reference.V8ValueError;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueIntegerObject;
import com.caoccao.javet.values.reference.V8ValueLongObject;
import com.caoccao.javet.values.reference.V8ValueMap;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValuePromise;
import com.caoccao.javet.values.reference.V8ValueProxy;
import com.caoccao.javet.values.reference.V8ValueSet;
import com.caoccao.javet.values.reference.V8ValueStringObject;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import com.caoccao.javet.values.reference.V8ValueTypedArray;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class V8Scope
implements IV8Creatable,
IJavetClosable {
    protected static final String ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY = "V8 runtime cannot be empty.";
    protected boolean closed = false;
    protected boolean escapable = false;
    protected V8Runtime v8Runtime;
    protected List<V8Value> values;

    public V8Scope() {
        this(null);
    }

    V8Scope(V8Runtime v8Runtime) {
        this.v8Runtime = v8Runtime;
        this.values = new ArrayList<V8Value>();
    }

    public <T extends V8Value> T add(T value) {
        this.values.add(Objects.requireNonNull(value));
        return value;
    }

    @Override
    public void close() throws JavetException {
        if (!this.closed) {
            if (!this.escapable) {
                JavetResourceUtils.safeClose(this.values);
            }
            this.closed = true;
        }
    }

    @Override
    public V8Module createV8Module(String moduleName, IV8ValueObject iV8ValueObject) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8Module(moduleName, iV8ValueObject));
    }

    @Override
    public V8ValueArray createV8ValueArray() throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8ValueArray());
    }

    @Override
    public V8ValueArrayBuffer createV8ValueArrayBuffer(int length) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8ValueArrayBuffer(length));
    }

    @Override
    public V8ValueArrayBuffer createV8ValueArrayBuffer(ByteBuffer byteBuffer) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8ValueArrayBuffer(byteBuffer));
    }

    @Override
    public V8ValueBigInteger createV8ValueBigInteger(BigInteger bigInteger) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8ValueBigInteger(bigInteger));
    }

    @Override
    public V8ValueBigInteger createV8ValueBigInteger(String bigIntegerValue) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8ValueBigInteger(bigIntegerValue));
    }

    @Override
    public V8ValueBoolean createV8ValueBoolean(boolean booleanValue) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.v8Runtime.createV8ValueBoolean(booleanValue);
    }

    @Override
    public V8ValueBooleanObject createV8ValueBooleanObject(boolean booleanValue) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.v8Runtime.createV8ValueBooleanObject(booleanValue);
    }

    @Override
    public V8ValueDataView createV8ValueDataView(V8ValueArrayBuffer v8ValueArrayBuffer) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8ValueDataView(v8ValueArrayBuffer));
    }

    @Override
    public V8ValueDouble createV8ValueDouble(double doubleValue) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.v8Runtime.createV8ValueDouble(doubleValue);
    }

    @Override
    public V8ValueDoubleObject createV8ValueDoubleObject(double doubleValue) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.v8Runtime.createV8ValueDoubleObject(doubleValue);
    }

    @Override
    public V8ValueError createV8ValueError(V8ValueErrorType v8ValueErrorType, String message) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.v8Runtime.createV8ValueError(v8ValueErrorType, message);
    }

    @Override
    public V8ValueFunction createV8ValueFunction(JavetCallbackContext javetCallbackContext) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8ValueFunction(javetCallbackContext));
    }

    @Override
    public V8ValueFunction createV8ValueFunction(String codeString) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8ValueFunction(codeString));
    }

    @Override
    public V8ValueInteger createV8ValueInteger(int integerValue) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.v8Runtime.createV8ValueInteger(integerValue);
    }

    @Override
    public V8ValueIntegerObject createV8ValueIntegerObject(int intValue) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.v8Runtime.createV8ValueIntegerObject(intValue);
    }

    @Override
    public V8ValueLong createV8ValueLong(long longValue) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.v8Runtime.createV8ValueLong(longValue);
    }

    @Override
    public V8ValueLongObject createV8ValueLongObject(long longValue) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.v8Runtime.createV8ValueLongObject(longValue);
    }

    @Override
    public V8ValueMap createV8ValueMap() throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8ValueMap());
    }

    @Override
    public V8ValueNull createV8ValueNull() {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.v8Runtime.createV8ValueNull();
    }

    @Override
    public V8ValueObject createV8ValueObject() throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8ValueObject());
    }

    @Override
    public V8ValuePromise createV8ValuePromise() throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8ValuePromise());
    }

    @Override
    public V8ValueProxy createV8ValueProxy(V8Value v8Value) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8ValueProxy(v8Value));
    }

    @Override
    public V8ValueSet createV8ValueSet() throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8ValueSet());
    }

    @Override
    public V8ValueString createV8ValueString(String str) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.v8Runtime.createV8ValueString(str);
    }

    @Override
    public V8ValueStringObject createV8ValueStringObject(String str) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.v8Runtime.createV8ValueStringObject(Objects.requireNonNull(str));
    }

    @Override
    public V8ValueSymbol createV8ValueSymbol(String description, boolean global) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8ValueSymbol(description, global));
    }

    @Override
    public V8ValueTypedArray createV8ValueTypedArray(V8ValueReferenceType type, int length) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.add(this.v8Runtime.createV8ValueTypedArray(type, length));
    }

    @Override
    public V8ValueUndefined createV8ValueUndefined() {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.v8Runtime.createV8ValueUndefined();
    }

    @Override
    public V8ValueZonedDateTime createV8ValueZonedDateTime(long jsTimestamp) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.v8Runtime.createV8ValueZonedDateTime(jsTimestamp);
    }

    @Override
    public V8ValueZonedDateTime createV8ValueZonedDateTime(ZonedDateTime zonedDateTime) throws JavetException {
        Objects.requireNonNull(this.v8Runtime, ERROR_MESSAGE_V8_RUNTIME_CANNOT_BE_EMPTY);
        return this.v8Runtime.createV8ValueZonedDateTime(zonedDateTime);
    }

    public <T extends V8Value> T get(int index) {
        return (T)this.values.get(index);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public boolean isEscapable() {
        return this.escapable;
    }

    public V8Scope setEscapable() {
        return this.setEscapable(true);
    }

    public V8Scope setEscapable(boolean escapable) {
        this.escapable = escapable;
        return this;
    }
}

