/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.builtin.V8ValueBuiltInReflect;

public interface IJavetProxyHandler<T, E extends Exception> {
    public static final String FUNCTION_NAME_TO_JSON = "toJSON";
    public static final String FUNCTION_NAME_TO_V8_VALUE = "toV8Value";
    public static final String PROXY_FUNCTION_NAME_APPLY = "apply";
    public static final String PROXY_FUNCTION_NAME_CONSTRUCT = "construct";
    public static final String PROXY_FUNCTION_NAME_DELETE_PROPERTY = "deleteProperty";
    public static final String PROXY_FUNCTION_NAME_GET = "get";
    public static final String PROXY_FUNCTION_NAME_HAS = "has";
    public static final String PROXY_FUNCTION_NAME_OWN_KEYS = "ownKeys";
    public static final String PROXY_FUNCTION_NAME_GET_OWN_PROPERTY_DESCRIPTOR = "getOwnPropertyDescriptor";
    public static final String PROXY_FUNCTION_NAME_SET = "set";

    default public V8Value apply(V8Value target, V8Value thisObject, V8ValueArray arguments) throws JavetException, E {
        try (V8ValueBuiltInReflect v8ValueBuiltInReflect = this.getV8Runtime().getGlobalObject().getBuiltInReflect();){
            V8Value v8Value = v8ValueBuiltInReflect.apply(target, thisObject, arguments);
            return v8Value;
        }
    }

    default public V8Value construct(V8Value target, V8ValueArray arguments, V8Value newTarget) throws JavetException, E {
        try (V8ValueBuiltInReflect v8ValueBuiltInReflect = this.getV8Runtime().getGlobalObject().getBuiltInReflect();){
            V8Value v8Value = v8ValueBuiltInReflect.construct(target, arguments, newTarget);
            return v8Value;
        }
    }

    default public V8ValueBoolean defineProperty(V8Value target, V8Value property, V8ValueObject descriptor) throws JavetException, E {
        try (V8ValueBuiltInReflect v8ValueBuiltInReflect = this.getV8Runtime().getGlobalObject().getBuiltInReflect();){
            V8ValueBoolean v8ValueBoolean = v8ValueBuiltInReflect.defineProperty(target, property, descriptor);
            return v8ValueBoolean;
        }
    }

    default public V8ValueBoolean deleteProperty(V8Value target, V8Value property) throws JavetException, E {
        try (V8ValueBuiltInReflect v8ValueBuiltInReflect = this.getV8Runtime().getGlobalObject().getBuiltInReflect();){
            V8ValueBoolean v8ValueBoolean = v8ValueBuiltInReflect.deleteProperty(target, property);
            return v8ValueBoolean;
        }
    }

    default public V8Value get(V8Value target, V8Value property, V8Value receiver) throws JavetException, E {
        try (V8ValueBuiltInReflect v8ValueBuiltInReflect = this.getV8Runtime().getGlobalObject().getBuiltInReflect();){
            V8Value v8Value = v8ValueBuiltInReflect._get(target, property);
            return v8Value;
        }
    }

    default public V8Value getOwnPropertyDescriptor(V8Value target, V8Value property) throws JavetException, E {
        try (V8ValueBuiltInReflect v8ValueBuiltInReflect = this.getV8Runtime().getGlobalObject().getBuiltInReflect();){
            V8Value v8Value = v8ValueBuiltInReflect.getOwnPropertyDescriptor(target, property);
            return v8Value;
        }
    }

    default public V8Value getPrototypeOf(V8Value target) throws JavetException, E {
        try (V8ValueBuiltInReflect v8ValueBuiltInReflect = this.getV8Runtime().getGlobalObject().getBuiltInReflect();){
            V8Value v8Value = v8ValueBuiltInReflect.getPrototypeOf(target);
            return v8Value;
        }
    }

    public T getTargetObject();

    public V8Runtime getV8Runtime();

    default public V8ValueBoolean has(V8Value target, V8Value property) throws JavetException, E {
        try (V8ValueBuiltInReflect v8ValueBuiltInReflect = this.getV8Runtime().getGlobalObject().getBuiltInReflect();){
            V8ValueBoolean v8ValueBoolean = v8ValueBuiltInReflect._has(target, property);
            return v8ValueBoolean;
        }
    }

    default public V8ValueBoolean isExtensible(V8Value target) throws JavetException, E {
        try (V8ValueBuiltInReflect v8ValueBuiltInReflect = this.getV8Runtime().getGlobalObject().getBuiltInReflect();){
            V8ValueBoolean v8ValueBoolean = v8ValueBuiltInReflect.isExtensible(target);
            return v8ValueBoolean;
        }
    }

    default public V8ValueArray ownKeys(V8Value target) throws JavetException, E {
        try (V8ValueBuiltInReflect v8ValueBuiltInReflect = this.getV8Runtime().getGlobalObject().getBuiltInReflect();){
            V8ValueArray v8ValueArray = v8ValueBuiltInReflect.ownKeys(target);
            return v8ValueArray;
        }
    }

    default public V8ValueBoolean preventExtensions(V8Value target) throws JavetException, E {
        try (V8ValueBuiltInReflect v8ValueBuiltInReflect = this.getV8Runtime().getGlobalObject().getBuiltInReflect();){
            V8ValueBoolean v8ValueBoolean = v8ValueBuiltInReflect.preventExtensions(target);
            return v8ValueBoolean;
        }
    }

    default public V8ValueBoolean set(V8Value target, V8Value propertyKey, V8Value propertyValue, V8Value receiver) throws JavetException, E {
        try (V8ValueBuiltInReflect v8ValueBuiltInReflect = this.getV8Runtime().getGlobalObject().getBuiltInReflect();){
            V8ValueBoolean v8ValueBoolean = v8ValueBuiltInReflect._set(target, propertyKey, propertyValue, receiver);
            return v8ValueBoolean;
        }
    }

    default public V8ValueBoolean setPrototypeOf(V8Value target, V8Value prototype) throws JavetException, E {
        try (V8ValueBuiltInReflect v8ValueBuiltInReflect = this.getV8Runtime().getGlobalObject().getBuiltInReflect();){
            V8ValueBoolean v8ValueBoolean = v8ValueBuiltInReflect.setPrototypeOf(target, prototype);
            return v8ValueBoolean;
        }
    }
}

