/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interception.logging;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interception.BaseJavetDirectCallableInterceptor;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.V8ValueObject;

public abstract class BaseJavetConsoleInterceptor
extends BaseJavetDirectCallableInterceptor {
    protected static final String JS_FUNCTION_DEBUG = "debug";
    protected static final String JS_FUNCTION_ERROR = "error";
    protected static final String JS_FUNCTION_INFO = "info";
    protected static final String JS_FUNCTION_LOG = "log";
    protected static final String JS_FUNCTION_TRACE = "trace";
    protected static final String JS_FUNCTION_WARN = "warn";
    protected static final String PROPERTY_CONSOLE = "console";
    protected static final String SPACE = " ";

    public BaseJavetConsoleInterceptor(V8Runtime v8Runtime) {
        super(v8Runtime);
    }

    public String concat(V8Value ... v8Values) {
        return V8ValueUtils.concat(SPACE, v8Values);
    }

    public abstract void consoleDebug(V8Value ... var1);

    public abstract void consoleError(V8Value ... var1);

    public abstract void consoleInfo(V8Value ... var1);

    public abstract void consoleLog(V8Value ... var1);

    public abstract void consoleTrace(V8Value ... var1);

    public abstract void consoleWarn(V8Value ... var1);

    @Override
    public JavetCallbackContext[] getCallbackContexts() {
        return new JavetCallbackContext[]{new JavetCallbackContext(JS_FUNCTION_DEBUG, (Object)this, JavetCallbackType.DirectCallNoThisAndNoResult, this::consoleDebug), new JavetCallbackContext(JS_FUNCTION_ERROR, (Object)this, JavetCallbackType.DirectCallNoThisAndNoResult, this::consoleError), new JavetCallbackContext(JS_FUNCTION_INFO, (Object)this, JavetCallbackType.DirectCallNoThisAndNoResult, this::consoleInfo), new JavetCallbackContext(JS_FUNCTION_LOG, (Object)this, JavetCallbackType.DirectCallNoThisAndNoResult, this::consoleLog), new JavetCallbackContext(JS_FUNCTION_TRACE, (Object)this, JavetCallbackType.DirectCallNoThisAndNoResult, this::consoleTrace), new JavetCallbackContext(JS_FUNCTION_WARN, (Object)this, JavetCallbackType.DirectCallNoThisAndNoResult, this::consoleWarn)};
    }

    @Override
    public boolean register(IV8ValueObject ... iV8ValueObjects) throws JavetException {
        boolean successful = true;
        try (V8ValueObject v8ValueObject = this.v8Runtime.createV8ValueObject();){
            v8ValueObject.bind(this);
            for (IV8ValueObject iV8ValueObject : iV8ValueObjects) {
                successful = iV8ValueObject.set((Object)PROPERTY_CONSOLE, (Object)v8ValueObject) & successful;
            }
            boolean bl = successful;
            return bl;
        }
    }

    @Override
    public boolean unregister(IV8ValueObject ... iV8ValueObjects) throws JavetException {
        boolean successful = true;
        for (IV8ValueObject iV8ValueObject : iV8ValueObjects) {
            successful = iV8ValueObject.delete(PROPERTY_CONSOLE) & successful;
        }
        return successful;
    }
}

