/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.enums;

import java.util.HashMap;
import java.util.Map;

public enum V8ValueErrorType {
    Error(0, "Error"),
    RangeError(1, "RangeError"),
    ReferenceError(2, "ReferenceError"),
    SyntaxError(3, "SyntaxError"),
    TypeError(4, "TypeError"),
    WasmCompileError(5, "CompileError"),
    WasmLinkError(6, "LinkError"),
    WasmRuntimeError(7, "RuntimeError"),
    UnknownError(8, "UnknownError");

    private static final V8ValueErrorType[] ALL_TYPES;
    private static final Map<String, V8ValueErrorType> TYPE_MAP;
    private final int id;
    private final String name;

    private V8ValueErrorType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static V8ValueErrorType parse(int id) {
        return ALL_TYPES[id];
    }

    public static V8ValueErrorType parse(String name) {
        return TYPE_MAP.getOrDefault(name, UnknownError);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    static {
        ALL_TYPES = new V8ValueErrorType[9];
        TYPE_MAP = new HashMap<String, V8ValueErrorType>();
        V8ValueErrorType[] v8ValueErrorTypeArray = V8ValueErrorType.values();
        int n = v8ValueErrorTypeArray.length;
        for (int i = 0; i < n; ++i) {
            V8ValueErrorType type;
            V8ValueErrorType.ALL_TYPES[type.getId()] = type = v8ValueErrorTypeArray[i];
            TYPE_MAP.put(type.getName(), type);
        }
    }
}

